/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommonUiProperties {
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_DETAILS = new VcsLogUiProperties.VcsLogUiProperty("Window.ShowDetails");
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_DIFF_PREVIEW = new VcsLogUiProperties.VcsLogUiProperty("Window.ShowDiffPreview");
    public static final Map<Integer, VcsLogUiProperties.VcsLogUiProperty<Integer>> COLUMN_WIDTH = ContainerUtil.newHashMap();
    public static final VcsLogUiProperties.VcsLogUiProperty<List<Integer>> COLUMN_ORDER = new VcsLogUiProperties.VcsLogUiProperty("Table.ColumnOrder");
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_ROOT_NAMES = new VcsLogUiProperties.VcsLogUiProperty("Table.ShowRootNames");

    public static void saveColumnWidth(@NotNull VcsLogUiProperties properties, int column, int width) {
        if (properties.exists(COLUMN_WIDTH.get(column)) && properties.get(COLUMN_WIDTH.get(column)) != width) {
            properties.set(COLUMN_WIDTH.get(column), width);
        }
    }

    public static int getColumnWidth(@NotNull VcsLogUiProperties properties, int column) {
        if (properties.exists(COLUMN_WIDTH.get(column))) {
            return properties.get(COLUMN_WIDTH.get(column));
        }
        return -1;
    }

    static {
        COLUMN_WIDTH.put(2, new TableColumnProperty("Author", 2));
        COLUMN_WIDTH.put(3, new TableColumnProperty("Date", 3));
    }

    public static class TableColumnProperty
    extends VcsLogUiProperties.VcsLogUiProperty<Integer> {
        private final int myColumn;

        public TableColumnProperty(@NotNull String name, int column) {
            super("Table." + name + "ColumnWidth");
            this.myColumn = column;
        }

        public int getColumn() {
            return this.myColumn;
        }
    }
}

