/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class HashImpl
implements Hash {
    private static final int BASE = 16;
    @NotNull
    private final byte[] myData;
    private final int myHashCode;

    @NotNull
    public static Hash build(@NotNull String inputStr) {
        byte[] data = HashImpl.buildData(inputStr);
        assert (data.length > 0) : "Can not build hash for string " + inputStr;
        return new HashImpl(data);
    }

    @NotNull
    public static Hash read(@NotNull DataInput in) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)in);
        if (length == 0) {
            throw new IOException("Can not read hash: data length is zero");
        }
        byte[] buf = new byte[length];
        in.readFully(buf);
        return new HashImpl(buf);
    }

    public void write(@NotNull DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myData.length);
        out.write(this.myData);
    }

    @NotNull
    private static byte[] buildData(@NotNull String inputStr) {
        int length = inputStr.length();
        byte even = (byte)(length % 2);
        byte[] data = new byte[length / 2 + 1 + even];
        data[0] = even;
        for (int i = 0; i < length / 2; ++i) {
            int k = HashImpl.parseChar(inputStr, 2 * i) * 16 + HashImpl.parseChar(inputStr, 2 * i + 1);
            data[i + 1] = (byte)(k - 128);
        }
        if (even == 1) {
            int k = HashImpl.parseChar(inputStr, length - 1);
            data[length / 2 + 1] = (byte)(k - 128);
        }
        return data;
    }

    private static int parseChar(@NotNull String inputString, int index) {
        int k = Character.digit(inputString.charAt(index), 16);
        if (k < 0) {
            throw new IllegalArgumentException("bad hash string: " + inputString);
        }
        return k;
    }

    private HashImpl(@NotNull byte[] hash) {
        this.myData = hash;
        this.myHashCode = Arrays.hashCode(hash);
    }

    @NotNull
    public String asString() {
        assert (this.myData.length > 0) : "bad length Hash.data";
        byte even = this.myData[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.myData.length; ++i) {
            int k1 = (this.myData[i] + 128) / 16;
            int k2 = (this.myData[i] + 128) % 16;
            char c1 = Character.forDigit(k1, 16);
            char c2 = Character.forDigit(k2, 16);
            if (i == this.myData.length - 1 && even == 1) {
                sb.append(c2);
                continue;
            }
            sb.append(c1).append(c2);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashImpl that = (HashImpl)o;
        return this.myHashCode == that.myHashCode && Arrays.equals(this.myData, that.myData);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String toShortString() {
        return VcsLogUtil.getShortHash(this.asString());
    }
}

