/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExecutingHeavyOrPowerSaveListener myListener;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        this.myProject = project;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myListener = new ExecutingHeavyOrPowerSaveListener(project, delayMs, this);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public Future<?> executeOutOfHeavyOrPowerSave(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull String title, @NotNull ProgressIndicator indicator) {
        return Futures.transformAsync(this.myListener.addTask(() -> {
            Disposable disposable = Disposer.newDisposable();
            ListenableFuture<?> future2 = HeavyAwareExecutor.runAsync(this.myProject, task2, title, indicator, () -> Disposer.dispose((Disposable)disposable));
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
            return future2;
        }), input -> input, (Executor)MoreExecutors.directExecutor());
    }

    public void dispose() {
    }

    @NotNull
    private static ListenableFuture<?> runAsync(@NotNull Project project, final @NotNull Consumer<? super ProgressIndicator> task2, @NotNull String title, @NotNull ProgressIndicator indicator, @NotNull Runnable continuation) {
        final SettableFuture future2 = SettableFuture.create();
        Task.Backgroundable wrapper2 = new Task.Backgroundable(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    task2.consume((Object)indicator);
                }
                finally {
                    future2.set(null);
                }
            }
        };
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(wrapper2, indicator, continuation);
        return future2;
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
            } else {
                command.run();
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS));
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener {
        @NotNull
        private final AtomicReference<List<Runnable>> myTasksToRun = new AtomicReference<ArrayList>(ContainerUtil.newArrayList());
        private final int myDelayMs;

        ExecutingHeavyOrPowerSaveListener(@NotNull Project project, int delayMs, @NotNull Disposable parent) {
            this.myDelayMs = delayMs;
            project.getMessageBus().connect(parent).subscribe(PowerSaveMode.TOPIC, (Object)this);
        }

        @NotNull
        public <T> ListenableFuture<ListenableFuture<T>> addTask(@NotNull Computable<? extends ListenableFuture<T>> task2) {
            SettableFuture future2 = SettableFuture.create();
            this.myTasksToRun.getAndUpdate(tasks -> ContainerUtil.concat((List)tasks, Collections.singletonList(ExecutingHeavyOrPowerSaveListener.wrap(task2, future2))));
            this.tryRun();
            return future2;
        }

        @NotNull
        private static <T> Runnable wrap(@NotNull Computable<? extends ListenableFuture<T>> task2, @NotNull SettableFuture<? super ListenableFuture<T>> future2) {
            return () -> {
                try {
                    future2.set(task2.compute());
                }
                catch (Throwable t) {
                    future2.setException(t);
                }
            };
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        List<Runnable> tasks = this.myTasksToRun.getAndSet(ContainerUtil.newArrayList());
                        tasks.forEach(Runnable::run);
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture = null;

        CancellingOnHeavyOrPowerSaveListener(@NotNull Project project, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future2 = this.myFuture;
                this.myFuture = null;
                future2.cancel(true);
            }
        }
    }
}

