/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.impl.VcsFileStatusInfoMerger;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class VcsChangesLazilyParsedDetails
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails,
VcsIndexableDetails {
    private static final Logger LOG = Logger.getInstance(VcsChangesLazilyParsedDetails.class);
    private static final WeakStringInterner ourPathsInterner = new WeakStringInterner();
    protected static final Changes EMPTY_CHANGES = new EmptyChanges();
    @NotNull
    protected final AtomicReference<Changes> myChanges = new AtomicReference();

    public VcsChangesLazilyParsedDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime) {
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
    }

    @Override
    @NotNull
    public Map<String, Change.Type> getModifiedPaths(int parent) {
        return this.myChanges.get().getModifiedPaths(parent);
    }

    @Override
    @NotNull
    public Collection<Couple<String>> getRenamedPaths(int parent) {
        return this.myChanges.get().getRenamedPaths(parent);
    }

    @NotNull
    public Collection<Change> getChanges() {
        try {
            return this.myChanges.get().getMergedChanges();
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public Collection<Change> getChanges(int parent) {
        try {
            return this.myChanges.get().getChanges(parent);
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public int size() {
        int size = 0;
        Changes changes2 = this.myChanges.get();
        if (changes2 instanceof UnparsedChanges) {
            for (int i = 0; i < this.getParents().size(); ++i) {
                size += ((UnparsedChanges)changes2).getChangesOutput().get(i).size();
            }
        } else {
            for (int i = 0; i < this.getParents().size(); ++i) {
                try {
                    size += changes2.getChanges(i).size();
                    continue;
                }
                catch (VcsException vcsException) {
                    // empty catch block
                }
            }
        }
        return size;
    }

    @Override
    public boolean hasRenames() {
        return true;
    }

    public static class ParsedChanges
    implements Changes {
        @NotNull
        private final Collection<Change> myMergedChanges;
        @NotNull
        private final List<? extends Collection<Change>> myChanges;

        ParsedChanges(@NotNull Collection<Change> mergedChanges, @NotNull List<? extends Collection<Change>> changes2) {
            this.myMergedChanges = mergedChanges;
            this.myChanges = changes2;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            return this.myMergedChanges;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            return this.myChanges.get(parent);
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            HashMap changes2 = ContainerUtil.newHashMap();
            for (Change change : this.getChanges(parent)) {
                Change.Type type = change.getType();
                if (type.equals((Object)Change.Type.MOVED)) continue;
                if (change.getAfterRevision() != null) {
                    changes2.put(change.getAfterRevision().getFile().getPath(), type);
                }
                if (change.getBeforeRevision() == null) continue;
                changes2.put(change.getBeforeRevision().getFile().getPath(), type);
            }
            return changes2;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (Change change : this.getChanges(parent)) {
                if (!change.getType().equals((Object)Change.Type.MOVED) || change.getAfterRevision() == null || change.getBeforeRevision() == null) continue;
                renames.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
            }
            return renames;
        }
    }

    protected abstract class UnparsedChanges
    implements Changes {
        @NotNull
        protected final Project myProject;
        @NotNull
        private final String myRootPrefix;
        @NotNull
        protected final List<List<VcsFileStatusInfo>> myChangesOutput;
        @NotNull
        private final VcsStatusMerger<VcsFileStatusInfo> myStatusMerger;

        public UnparsedChanges(@NotNull Project project, List<List<VcsFileStatusInfo>> changesOutput) {
            this.myRootPrefix = ourPathsInterner.intern(VcsChangesLazilyParsedDetails.this.getRoot().getPath() + "/");
            this.myStatusMerger = new VcsFileStatusInfoMerger();
            this.myProject = project;
            this.myChangesOutput = changesOutput;
        }

        @NotNull
        protected ParsedChanges parseChanges() throws VcsException {
            List<Change> mergedChanges = this.parseMergedChanges();
            List<Collection<Change>> changes2 = this.computeChanges(mergedChanges);
            ParsedChanges parsedChanges = new ParsedChanges(mergedChanges, changes2);
            VcsChangesLazilyParsedDetails.this.myChanges.compareAndSet(this, parsedChanges);
            return parsedChanges;
        }

        @NotNull
        private List<Change> parseMergedChanges() throws VcsException {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> statuses = this.getMergedStatusInfo();
            List<Change> changes2 = this.parseStatusInfo(ContainerUtil.map(statuses, VcsStatusMerger.MergedStatusInfo::getStatusInfo), 0);
            LOG.assertTrue(changes2.size() == statuses.size(), (Object)("Incorrectly parsed statuses " + statuses + " to changes " + changes2));
            if (VcsChangesLazilyParsedDetails.this.getParents().size() <= 1) {
                return changes2;
            }
            ArrayList<Change> wrappedChanges = new ArrayList<Change>(statuses.size());
            for (int i = 0; i < statuses.size(); ++i) {
                wrappedChanges.add(new MyMergedChange(changes2.get(i), statuses.get(i)));
            }
            return wrappedChanges;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException {
            return this.parseChanges().getMergedChanges();
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) throws VcsException {
            return this.parseChanges().getChanges(parent);
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            HashMap changes2 = ContainerUtil.newHashMap();
            for (VcsFileStatusInfo status : this.myChangesOutput.get(parent)) {
                String secondPath = status.getSecondPath();
                if (secondPath != null) continue;
                changes2.put(this.absolutePath(status.getFirstPath()), status.getType());
            }
            return changes2;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (VcsFileStatusInfo status : this.myChangesOutput.get(parent)) {
                String secondPath = status.getSecondPath();
                if (secondPath == null) continue;
                renames.add(Couple.of((Object)this.absolutePath(status.getFirstPath()), (Object)this.absolutePath(secondPath)));
            }
            return renames;
        }

        @NotNull
        private String absolutePath(@NotNull String path) {
            return this.myRootPrefix + path;
        }

        @NotNull
        private List<Collection<Change>> computeChanges(@NotNull Collection<Change> mergedChanges) throws VcsException {
            if (this.myChangesOutput.size() == 1) {
                return Collections.singletonList(mergedChanges);
            }
            ArrayList changes2 = ContainerUtil.newArrayListWithCapacity((int)this.myChangesOutput.size());
            for (int i = 0; i < this.myChangesOutput.size(); ++i) {
                changes2.add(this.parseStatusInfo(this.myChangesOutput.get(i), i));
            }
            return changes2;
        }

        @NotNull
        protected abstract List<Change> parseStatusInfo(@NotNull List<VcsFileStatusInfo> var1, int var2) throws VcsException;

        @NotNull
        private List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> getMergedStatusInfo() {
            return this.myStatusMerger.merge(this.myChangesOutput);
        }

        @NotNull
        protected List<List<VcsFileStatusInfo>> getChangesOutput() {
            return this.myChangesOutput;
        }

        private class MyMergedChange
        extends MergedChange {
            @NotNull
            private final VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> myStatusInfo;
            @NotNull
            private final Supplier<List<Change>> mySourceChanges;

            MyMergedChange(@NotNull Change change, VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> statusInfo) {
                super(change);
                this.myStatusInfo = statusInfo;
                this.mySourceChanges = Suppliers.memoize(() -> {
                    ArrayList sourceChanges = ContainerUtil.newArrayList();
                    try {
                        for (int parent = 0; parent < this.myStatusInfo.getMergedStatusInfos().size(); ++parent) {
                            sourceChanges.addAll(UnparsedChanges.this.parseStatusInfo(Collections.singletonList(this.myStatusInfo.getMergedStatusInfos().get(parent)), parent));
                        }
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                    return sourceChanges;
                });
            }

            @Override
            public List<Change> getSourceChanges() {
                return (List)this.mySourceChanges.get();
            }
        }
    }

    protected static class EmptyChanges
    implements Changes {
        protected EmptyChanges() {
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            return ContainerUtil.emptyList();
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            return ContainerUtil.emptyList();
        }

        @Override
        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int parent) {
            return Collections.emptyMap();
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            return ContainerUtil.emptyList();
        }
    }

    public static interface Changes {
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException;

        @NotNull
        public Collection<Change> getChanges(int var1) throws VcsException;

        @NotNull
        public Map<String, Change.Type> getModifiedPaths(int var1);

        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int var1);
    }
}

