/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    public static final String TAB_NAME = "Log";
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer = new JBPanel((LayoutManager)new BorderLayout());
    @Nullable
    private Consumer<? super VcsLogUiImpl> myOnCreatedListener;
    @Nullable
    private volatile VcsLogUiImpl myUi;

    public VcsLogContentProvider(@NotNull Project project, @NotNull VcsProjectLog projectLog) {
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)projectLog);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager logManager) {
                VcsLogContentProvider.this.addMainUi(logManager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager logManager) {
                VcsLogContentProvider.this.disposeMainUi();
            }
        });
        VcsLogManager manager = this.myProjectLog.getLogManager();
        if (manager != null) {
            this.addMainUi(manager);
        }
    }

    @Nullable
    public VcsLogUiImpl getUi() {
        return this.myUi;
    }

    private void addMainUi(@NotNull VcsLogManager logManager) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myUi = logManager.createLogUi("MAIN", true);
            VcsLogPanel panel2 = new VcsLogPanel(logManager, this.myUi);
            this.myContainer.add((Component)((Object)panel2), "Center");
            DataManager.registerDataProvider((JComponent)this.myContainer, (DataProvider)panel2);
            if (this.myOnCreatedListener != null) {
                this.myOnCreatedListener.consume((Object)this.myUi);
            }
            this.myOnCreatedListener = null;
        }
    }

    private void disposeMainUi() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myContainer.removeAll();
        DataManager.removeDataProvider((JComponent)this.myContainer);
        this.myOnCreatedListener = null;
        if (this.myUi != null) {
            VcsLogUiImpl ui = this.myUi;
            this.myUi = null;
            Disposer.dispose((Disposable)ui);
        }
    }

    @Override
    public JComponent initContent() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.myProjectLog.createLog(true));
        return this.myContainer;
    }

    public void executeOnMainUiCreated(@NotNull Consumer<? super VcsLogUiImpl> consumer) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myOnCreatedListener = consumer;
        } else {
            consumer.consume((Object)this.myUi);
        }
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    @Nullable
    public static VcsLogContentProvider getInstance(@NotNull Project project) {
        for (ChangesViewContentEP ep : ChangesViewContentEP.EP_NAME.getExtensionList((AreaInstance)project)) {
            if (!ep.getClassName().equals(VcsLogContentProvider.class.getName())) continue;
            return (VcsLogContentProvider)ep.getCachedInstance();
        }
        return null;
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            VcsRoot[] roots = ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots();
            return !VcsLogManager.findLogProviders(Arrays.asList(roots), project).isEmpty();
        }
    }
}

