/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentUtil {
    @Nullable
    private static AbstractVcsLogUi getLogUi(@NotNull JComponent c) {
        VcsLogPanel vcsLogPanel = null;
        if (c instanceof VcsLogPanel) {
            vcsLogPanel = (VcsLogPanel)((Object)c);
        } else if (c instanceof JPanel) {
            vcsLogPanel = (VcsLogPanel)((Object)ContainerUtil.findInstance((Object[])c.getComponents(), VcsLogPanel.class));
        }
        if (vcsLogPanel != null) {
            return vcsLogPanel.getUi();
        }
        return null;
    }

    public static <U extends AbstractVcsLogUi> boolean findAndSelectContent(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        return VcsLogContentUtil.findAndSelect(project, clazz, condition) != null;
    }

    @Nullable
    public static <U extends AbstractVcsLogUi> U findAndSelect(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        if (toolWindow == null) {
            return null;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent(manager, (Condition<? super JComponent>)((Condition)c -> {
            AbstractVcsLogUi ui = VcsLogContentUtil.getLogUi(c);
            if (ui != null) {
                return clazz.isInstance(ui) && condition.value((Object)ui);
            }
            return false;
        }));
        if (component == null) {
            return null;
        }
        if (!toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        if (!ContentUtilEx.selectContent(manager, component, true)) {
            return null;
        }
        return (U)VcsLogContentUtil.getLogUi(component);
    }

    public static boolean selectLogUi(@NotNull Project project, @NotNull VcsLogUi ui) {
        return VcsLogContentUtil.findAndSelectContent(project, AbstractVcsLogUi.class, u -> u.equals(ui));
    }

    @Nullable
    public static String getId(@NotNull Content content) {
        AbstractVcsLogUi ui = VcsLogContentUtil.getLogUi(content.getComponent());
        if (ui == null) {
            return null;
        }
        return ui.getId();
    }

    @NotNull
    public static String generateTabId(@NotNull Project project) {
        ContentManager contentManager = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS).getContentManager();
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(contentManager, "Log");
        Set existingIds = tabbedContent != null ? ContainerUtil.map2SetNotNull((Collection)tabbedContent.getTabs(), pair -> {
            AbstractVcsLogUi ui = VcsLogContentUtil.getLogUi((JComponent)pair.second);
            if (ui == null) {
                return null;
            }
            return ui.getId();
        }) : ContainerUtil.map2SetNotNull(Arrays.asList(contentManager.getContents()), content -> {
            if (!"Log".equals(content.getUserData(Content.TAB_GROUP_NAME_KEY))) {
                return null;
            }
            return VcsLogContentUtil.getId(content);
        });
        int i = 1;
        String idString;
        while (existingIds.contains(idString = Integer.toString(i))) {
            ++i;
        }
        return idString;
    }

    public static <U extends AbstractVcsLogUi> U openLogTab(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull String tabGroupName, @NotNull String shortName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory, boolean focus) {
        U logUi = logManager.createLogUi(factory, true);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (AbstractVcsLogUi)logUi)), tabGroupName, shortName, focus, logUi);
        if (focus) {
            toolWindow.activate(null);
        }
        logManager.scheduleInitialization();
        return logUi;
    }

    public static boolean closeLogTab(@NotNull ContentManager manager, @NotNull String tabId) {
        return ContentUtilEx.closeContentTab(manager, (Condition<? super JComponent>)((Condition)c -> {
            AbstractVcsLogUi ui = VcsLogContentUtil.getLogUi(c);
            if (ui != null) {
                return ui.getId().equals(tabId);
            }
            return false;
        }));
    }

    public static void openMainLogAndExecute(@NotNull Project project, @NotNull Consumer<? super VcsLogUiImpl> consumer) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!VcsLogContentUtil.selectMainLog(window)) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Vcs Log is not available", MessageType.WARNING, new NamedRunnable[0]);
            return;
        }
        Runnable runConsumer = () -> ((VcsLogContentProvider)ObjectUtils.notNull((Object)VcsLogContentProvider.getInstance(project))).executeOnMainUiCreated(consumer);
        if (!window.isVisible()) {
            window.activate(runConsumer);
        } else {
            runConsumer.run();
        }
    }

    private static boolean selectMainLog(@NotNull ToolWindow window) {
        Content[] contents;
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    public static void renameLogUi(@NotNull Project project, @NotNull VcsLogUiImpl ui, @NotNull String newName) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        if (toolWindow == null) {
            return;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent(manager, (Condition<? super JComponent>)((Condition)c -> ui == VcsLogContentUtil.getLogUi(c)));
        if (component == null) {
            return;
        }
        ContentUtilEx.renameTabbedContent(manager, component, newName);
    }
}

