/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Consumer<? super Throwable> myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @NotNull
    private final VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<? extends VcsRoot> roots) {
        this(project, uiProperties, roots, true, null);
    }

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<? extends VcsRoot> roots, boolean scheduleRefreshImmediately, @Nullable Consumer<? super Throwable> recreateHandler) {
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        Map<VirtualFile, VcsLogProvider> logProviders = VcsLogManager.findLogProviders(roots, this.myProject);
        MyFatalErrorsHandler fatalErrorsHandler = new MyFatalErrorsHandler();
        this.myLogData = new VcsLogData(this.myProject, logProviders, fatalErrorsHandler, this);
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
    }

    public void scheduleInitialization() {
        this.myLogData.initialize();
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        return this.myLogData;
    }

    @NotNull
    public VcsLogColorManagerImpl getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public VcsLogTabsProperties getUiProperties() {
        return this.myUiProperties;
    }

    @NotNull
    public VcsLogUiImpl createLogUi(@NotNull String logId, boolean isToolWindowTab) {
        return this.createLogUi(this.getMainLogUiFactory(logId, null), isToolWindowTab);
    }

    @NotNull
    public VcsLogUiFactory<? extends VcsLogUiImpl> getMainLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        return new MainVcsLogUiFactory(logId, filters);
    }

    @NotNull
    public <U extends AbstractVcsLogUi> U createLogUi(@NotNull VcsLogUiFactory<U> factory, boolean isToolWindowTab) {
        U ui = factory.createLogUi(this.myProject, this.myLogData);
        Disposable disposable = isToolWindowTab ? this.myTabsLogRefresher.addTabToWatch(((AbstractVcsLogUi)ui).getId(), ((AbstractVcsLogUi)ui).getRefresher()) : this.myPostponableRefresher.addLogWindow(((AbstractVcsLogUi)ui).getRefresher());
        Disposer.register(ui, (Disposable)disposable);
        ((AbstractVcsLogUi)ui).requestFocus();
        return ui;
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key, value) -> providers2roots.putValue(value, key));
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<? extends VcsRoot> roots, @NotNull Project project) {
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)project);
        block0: for (VcsRoot vcsRoot : roots) {
            AbstractVcs vcs = vcsRoot.getVcs();
            VirtualFile path = vcsRoot.getPath();
            if (vcs == null || path == null) {
                LOG.debug("Skipping invalid VCS root: " + vcsRoot);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        return logProviders;
    }

    public void dispose(@Nullable Runnable callback2) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myTabsLogRefresher.closeLogTabs();
        Disposer.dispose((Disposable)this.myTabsLogRefresher);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Disposer.dispose((Disposable)this);
            if (callback2 != null) {
                callback2.run();
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
    }

    private class MainVcsLogUiFactory
    implements VcsLogUiFactory<VcsLogUiImpl> {
        @NotNull
        private final String myLogId;
        @Nullable
        private final VcsLogFilterCollection myFilters;

        MainVcsLogUiFactory(@Nullable String logId, VcsLogFilterCollection filters) {
            this.myLogId = logId;
            this.myFilters = filters;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            MainVcsLogUiProperties properties = VcsLogManager.this.myUiProperties.createProperties(this.myLogId);
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
            PermanentGraph.SortType initialSortType = properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE);
            VcsLogFilterCollection initialFilters = this.myFilters == null ? VcsLogFilterObject.collection(new VcsLogFilter[0]) : this.myFilters;
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, initialFilters, initialSortType, vcsLogFilterer, this.myLogId);
            return new VcsLogUiImpl(this.myLogId, logData, VcsLogManager.this.myColorManager, properties, refresher, this.myFilters);
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends AbstractVcsLogUi> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Throwable e) {
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug("Vcs Log storage is broken and is being recreated", e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Throwable e) {
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.this.myRecreateMainLogHandler.consume((Object)e));
            } else {
                LOG.error(e);
            }
            if (source instanceof VcsLogStorage) {
                ((VcsLogModifiableIndex)VcsLogManager.this.myLogData.getIndex()).markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@NotNull String message) {
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }
    }
}

