/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.Tabs.Properties", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VcsLogProjectTabsProperties
implements PersistentStateComponent<State>,
VcsLogTabsProperties {
    public static final String MAIN_LOG_ID = "MAIN";
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;
    private State myState = new State();

    public VcsLogProjectTabsProperties(@NotNull VcsLogApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.migrateRecentItems();
    }

    private void migrateRecentItems() {
        if (ContainerUtil.isEmpty(this.myState.RECENT_FILTERS)) {
            this.myState.RECENT_FILTERS = ContainerUtil.newHashMap();
            HashMultiset branchFrequencies = HashMultiset.create();
            HashMultiset userFrequencies = HashMultiset.create();
            for (Map.Entry<String, VcsLogUiPropertiesImpl.State> entry : this.myState.TAB_STATES.entrySet()) {
                if (entry.getKey().startsWith("EXTERNAL")) continue;
                VcsLogUiPropertiesImpl.State s = entry.getValue();
                branchFrequencies.addAll((Collection)ContainerUtil.map(s.RECENTLY_FILTERED_BRANCH_GROUPS, RecentGroup::new));
                userFrequencies.addAll((Collection)ContainerUtil.map(s.RECENTLY_FILTERED_USER_GROUPS, RecentGroup::new));
                s.RECENTLY_FILTERED_BRANCH_GROUPS.clear();
                s.RECENTLY_FILTERED_USER_GROUPS.clear();
            }
            List sortedBranches = ContainerUtil.sorted((Collection)branchFrequencies.elementSet(), Comparator.comparingInt(arg_0 -> VcsLogProjectTabsProperties.lambda$migrateRecentItems$0((Multiset)branchFrequencies, arg_0)));
            List sortedUsers = ContainerUtil.sorted((Collection)userFrequencies.elementSet(), Comparator.comparingInt(arg_0 -> VcsLogProjectTabsProperties.lambda$migrateRecentItems$1((Multiset)userFrequencies, arg_0)));
            this.myState.RECENT_FILTERS.put("Branch", ContainerUtil.newArrayList((Iterable)ContainerUtil.getFirstItems((List)sortedBranches, (int)10)));
            this.myState.RECENT_FILTERS.put("User", ContainerUtil.newArrayList((Iterable)ContainerUtil.getFirstItems((List)sortedUsers, (int)10)));
        }
    }

    @Deprecated
    @Nullable
    public VcsLogUiPropertiesImpl.State removeTabState(@NotNull String id) {
        return this.myState.TAB_STATES.remove(id);
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties createProperties(@NotNull String id) {
        this.myState.TAB_STATES.putIfAbsent(id, new VcsLogUiPropertiesImpl.State());
        return new MyVcsLogUiPropertiesImpl(id);
    }

    public void addTab(@NotNull String tabId) {
        this.myState.OPEN_TABS.add(tabId);
    }

    public void removeTab(@NotNull String tabId) {
        this.myState.OPEN_TABS.remove(tabId);
    }

    public void resetState(@NotNull String tabId) {
        this.myState.TAB_STATES.put(tabId, null);
    }

    @NotNull
    public List<String> getTabs() {
        return ContainerUtil.newArrayList(this.myState.OPEN_TABS);
    }

    public static void addRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName, @NotNull Collection<String> values) {
        ArrayList recentGroups = stateField.get(filterName);
        if (recentGroups == null) {
            recentGroups = ContainerUtil.newArrayList();
            stateField.put(filterName, recentGroups);
        }
        RecentGroup group = new RecentGroup(values);
        recentGroups.remove(group);
        recentGroups.add(0, group);
        while (recentGroups.size() > 10) {
            recentGroups.remove(recentGroups.size() - 1);
        }
    }

    @NotNull
    public static List<List<String>> getRecentGroup(@NotNull Map<String, List<RecentGroup>> stateField, @NotNull String filterName) {
        List<RecentGroup> values = stateField.get(filterName);
        if (values == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.map2List(values, group -> group.FILTER_VALUES);
    }

    private static /* synthetic */ int lambda$migrateRecentItems$1(Multiset userFrequencies, RecentGroup value) {
        return -userFrequencies.count((Object)value);
    }

    private static /* synthetic */ int lambda$migrateRecentItems$0(Multiset branchFrequencies, RecentGroup value) {
        return -branchFrequencies.count((Object)value);
    }

    private class MyVcsLogUiPropertiesImpl
    extends VcsLogUiPropertiesImpl<VcsLogUiPropertiesImpl.State> {
        private final String myId;

        MyVcsLogUiPropertiesImpl(String id) {
            super(VcsLogProjectTabsProperties.this.myAppSettings);
            this.myId = id;
        }

        @Override
        @NotNull
        public VcsLogUiPropertiesImpl.State getState() {
            VcsLogUiPropertiesImpl.State state = ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.get(this.myId);
            if (state == null) {
                state = new VcsLogUiPropertiesImpl.State();
                ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
            }
            return state;
        }

        public void loadState(@NotNull VcsLogUiPropertiesImpl.State state) {
            ((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
        }

        @Override
        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
            VcsLogProjectTabsProperties.addRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName, values);
        }

        @Override
        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            return VcsLogProjectTabsProperties.getRecentGroup(((VcsLogProjectTabsProperties)VcsLogProjectTabsProperties.this).myState.RECENT_FILTERS, filterName);
        }
    }

    public static class RecentGroup {
        @XCollection
        public List<String> FILTER_VALUES = ContainerUtil.newArrayList();

        public RecentGroup() {
        }

        public RecentGroup(@NotNull Collection<String> values) {
            this.FILTER_VALUES.addAll(values);
        }

        public RecentGroup(@NotNull VcsLogUiPropertiesImpl.UserGroup oldGroup) {
            this(oldGroup.users);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentGroup group = (RecentGroup)o;
            return Objects.equals(this.FILTER_VALUES, group.FILTER_VALUES);
        }

        public int hashCode() {
            return Objects.hash(this.FILTER_VALUES);
        }
    }

    public static class State {
        public Map<String, VcsLogUiPropertiesImpl.State> TAB_STATES = ContainerUtil.newTreeMap();
        public LinkedHashSet<String> OPEN_TABS = ContainerUtil.newLinkedHashSet();
        public Map<String, List<RecentGroup>> RECENT_FILTERS = ContainerUtil.newHashMap();
    }
}

