/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogProjectTabsProperties myUiProperties;
    private boolean myIsLogDisposing = false;

    public VcsLogTabsManager(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Disposable parent) {
        this.myProject = project;
        this.myUiProperties = uiProperties;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                VcsLogTabsManager.this.myIsLogDisposing = false;
                VcsLogTabsManager.this.createLogTabs(manager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }
        });
    }

    private void createLogTabs(@NotNull VcsLogManager manager) {
        List<String> tabIds = this.myUiProperties.getTabs();
        for (String tabId : tabIds) {
            this.openLogTab(manager, tabId, false, null);
        }
    }

    @NotNull
    public List<String> getTabs() {
        return this.myUiProperties.getTabs();
    }

    public void openAnotherLogTab(@NotNull VcsLogManager manager) {
        this.openAnotherLogTab(manager, null);
    }

    @NotNull
    public VcsLogUiImpl openAnotherLogTab(@NotNull VcsLogManager manager, @Nullable VcsLogFilterCollection filters) {
        return this.openLogTab(manager, VcsLogContentUtil.generateTabId(this.myProject), true, filters);
    }

    @NotNull
    private VcsLogUiImpl openLogTab(@NotNull VcsLogManager manager, @NotNull String tabId, boolean focus, @Nullable VcsLogFilterCollection filters) {
        if (filters != null) {
            this.myUiProperties.resetState(tabId);
        }
        PersistentVcsLogUiFactory factory = new PersistentVcsLogUiFactory(manager.getMainLogUiFactory(tabId, filters));
        VcsLogUiImpl ui = VcsLogContentUtil.openLogTab(this.myProject, manager, "Log", tabId, factory, focus);
        this.updateTabName(ui);
        ui.addFilterListener(() -> this.updateTabName(ui));
        return ui;
    }

    private void updateTabName(@NotNull VcsLogUiImpl ui) {
        VcsLogContentUtil.renameLogUi(this.myProject, ui, VcsLogTabsManager.generateDisplayName(ui));
    }

    @NotNull
    private static String generateDisplayName(@NotNull VcsLogUiImpl ui) {
        VcsLogFilterCollection filters = ui.getFilterUi().getFilters();
        if (filters.isEmpty()) {
            return "all";
        }
        return StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<VcsLogUiImpl> {
        private final VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> myFactory;

        PersistentVcsLogUiFactory(VcsLogManager.VcsLogUiFactory<? extends VcsLogUiImpl> factory) {
            this.myFactory = factory;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            VcsLogUiImpl ui = this.myFactory.createLogUi(project, logData);
            VcsLogTabsManager.this.myUiProperties.addTab(ui.getId());
            Disposer.register((Disposable)ui, () -> {
                if (Disposer.isDisposing((Disposable)VcsLogTabsManager.this.myProject) || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                VcsLogTabsManager.this.myUiProperties.removeTab(ui.getId());
            });
            return ui;
        }
    }
}

