/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsWatcher
implements Disposable {
    private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
    private static final Logger LOG = Logger.getInstance(VcsLogTabsWatcher.class);
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final ToolWindowManagerEx myToolWindowManager;
    @NotNull
    private final MyRefreshPostponedEventsListener myPostponedEventsListener;
    @Nullable
    private ToolWindow myToolWindow;
    private boolean myIsVisible;
    @Nullable
    private MessageBusConnection myConnection;

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher refresher) {
        this.myRefresher = refresher;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)this.myPostponedEventsListener);
            this.installContentListener();
        }, project.getDisposed());
    }

    @Nullable
    private String getSelectedTabId() {
        Content content;
        if (this.myToolWindow != null && this.myToolWindow.isVisible() && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            return VcsLogContentUtil.getId(content);
        }
        return null;
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String tabId, @NotNull VisiblePackRefresher refresher) {
        return this.myRefresher.addLogWindow(new VcsLogTab(refresher, tabId));
    }

    private void installContentListener() {
        ToolWindow window = this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (window != null) {
            this.myToolWindow = window;
            this.myIsVisible = this.myToolWindow.isVisible();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
        }
    }

    private void removeListeners() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
        if (this.myToolWindow != null) {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            for (Content content : this.myToolWindow.getContentManager().getContents()) {
                if (!(content instanceof TabbedContent)) continue;
                content.removePropertyChangeListener((PropertyChangeListener)this.myPostponedEventsListener);
            }
        }
    }

    public void closeLogTabs() {
        if (this.myToolWindow != null) {
            List<String> tabs2 = this.getTabs();
            for (String tabId : tabs2) {
                boolean closed = VcsLogContentUtil.closeLogTab(this.myToolWindow.getContentManager(), tabId);
                LOG.assertTrue(closed, (Object)("Could not find content component for tab " + tabId + "\nExisting content: " + Arrays.toString(this.myToolWindow.getContentManager().getContents()) + "\nTabs to close: " + tabs2));
            }
        }
    }

    @NotNull
    private List<String> getTabs() {
        return ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogTab.class).map(VcsLogTab::getTabId).filter(tabId -> !"MAIN".equals(tabId))).toList();
    }

    public void dispose() {
        this.removeListeners();
    }

    private class MyRefreshPostponedEventsListener
    extends ContentManagerAdapter
    implements ToolWindowManagerListener,
    PropertyChangeListener {
        private MyRefreshPostponedEventsListener() {
        }

        private void selectionChanged() {
            String tabId = VcsLogTabsWatcher.this.getSelectedTabId();
            if (tabId != null) {
                this.selectionChanged(tabId);
            }
        }

        private void selectionChanged(@NotNull String tabId) {
            PostponableLogRefresher.VcsLogWindow logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(VcsLogTabsWatcher.this.myRefresher.getLogWindows(), window -> window instanceof VcsLogTab && ((VcsLogTab)window).myTabId.equals(tabId));
            if (logWindow != null) {
                LOG.debug("Selected log window '" + logWindow + "'");
                VcsLogUsageTriggerCollector.triggerUsage("TabNavigation");
                VcsLogTabsWatcher.this.myRefresher.refresherActivated(logWindow.getRefresher(), false);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            String tabId;
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation()) && (tabId = VcsLogContentUtil.getId(event.getContent())) != null) {
                this.selectionChanged(tabId);
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void stateChanged() {
            if (VcsLogTabsWatcher.this.myToolWindow == null) {
                return;
            }
            if (VcsLogTabsWatcher.this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID) == null) {
                VcsLogTabsWatcher.this.removeListeners();
            } else if (VcsLogTabsWatcher.this.myIsVisible != VcsLogTabsWatcher.this.myToolWindow.isVisible()) {
                VcsLogTabsWatcher.this.myIsVisible = VcsLogTabsWatcher.this.myToolWindow.isVisible();
                this.selectionChanged();
            }
        }

        @Override
        public void toolWindowRegistered(@NotNull String toolWindowId) {
            if (toolWindowId.equals(TOOLWINDOW_ID)) {
                VcsLogTabsWatcher.this.installContentListener();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }
    }

    public class VcsLogTab
    extends PostponableLogRefresher.VcsLogWindow {
        @NotNull
        private final String myTabId;

        public VcsLogTab(@NotNull VisiblePackRefresher refresher, String tabId) {
            super(refresher);
            this.myTabId = tabId;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.this.getSelectedTabId();
            return selectedTab != null && this.myTabId.equals(selectedTab);
        }

        @NotNull
        public String getTabId() {
            return this.myTabId;
        }

        @Override
        public String toString() {
            return "VcsLogTab '" + this.myTabId + '\'';
        }
    }
}

