/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager = new LazyVcsLogManager();
    private int myRecreatedLogCount = 0;

    public VcsProjectLog(@NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties) {
        this.myProject = project;
        this.myMessageBus = messageBus;
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, messageBus, uiProperties, this);
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @NotNull
    private Collection<VcsRoot> getVcsRoots() {
        return Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcsRoots());
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        return this.myTabsManager;
    }

    private void recreateLog() {
        UIUtil.invokeLaterIfNeeded(() -> this.myLogManager.drop(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.hasDvcsRoots()) {
                this.createLog(false);
            }
        }));
    }

    private void recreateOnError(@NotNull Throwable t) {
        if (++this.myRecreatedLogCount % 5 == 0) {
            String message = String.format("VCS Log was recreated %d times due to data corruption\nDelete %s directory and restart %s if this happens often.\n%s", this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName(), t.getMessage());
            LOG.error(message, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug("Recreating VCS Log after storage corruption", t);
        }
        this.recreateLog();
    }

    public void createLog(boolean forceInit) {
        VcsLogManager logManager = this.myLogManager.getValue();
        ApplicationManager.getApplication().invokeLater(() -> {
            VcsLogCachesInvalidator invalidator;
            if (logManager.isLogVisible() || forceInit) {
                logManager.scheduleInitialization();
            } else if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class)))).isValid()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            }
        });
    }

    private boolean hasDvcsRoots() {
        return !VcsLogManager.findLogProviders(this.getVcsRoots(), this.myProject).isEmpty();
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        return (VcsProjectLog)ServiceManager.getService((Project)project, VcsProjectLog.class);
    }

    public void dispose() {
        this.myLogManager.drop();
    }

    public static interface ProjectLogListener {
        public void logCreated(@NotNull VcsLogManager var1);

        public void logDisposed(@NotNull VcsLogManager var1);
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
                connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> projectLog.recreateLog());
                if (projectLog.hasDvcsRoots()) {
                    projectLog.createLog(false);
                }
            });
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public synchronized VcsLogManager getValue() {
            if (this.myValue == null) {
                VcsLogManager value;
                this.myValue = value = this.compute();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!VcsProjectLog.this.myProject.isDisposed()) {
                        ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value);
                    }
                });
            }
            return this.myValue;
        }

        @NotNull
        protected synchronized VcsLogManager compute() {
            return new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, VcsProjectLog.this.getVcsRoots(), false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
        }

        public synchronized void drop() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            this.drop(null);
        }

        public synchronized void drop(@Nullable Runnable callback2) {
            if (this.myValue != null) {
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(this.myValue);
                this.myValue.dispose(callback2);
                this.myValue = null;
            } else if (callback2 != null) {
                ApplicationManager.getApplication().executeOnPooledThread(callback2);
            }
        }

        @Nullable
        public synchronized VcsLogManager getCached() {
            return this.myValue;
        }
    }
}

