/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import org.jetbrains.annotations.NotNull;

public final class VcsRefImpl
implements VcsRef {
    private static final WeakStringInterner ourNames = new WeakStringInterner();
    @NotNull
    private final Hash myCommitHash;
    @NotNull
    private final String myName;
    @NotNull
    private final VcsRefType myType;
    @NotNull
    private final VirtualFile myRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsRefImpl(@NotNull Hash commitHash, @NotNull String name, @NotNull VcsRefType type, @NotNull VirtualFile root) {
        this.myCommitHash = commitHash;
        this.myType = type;
        this.myRoot = root;
        WeakStringInterner weakStringInterner = ourNames;
        synchronized (weakStringInterner) {
            this.myName = ourNames.intern(name);
        }
    }

    @NotNull
    public VcsRefType getType() {
        return this.myType;
    }

    @NotNull
    public Hash getCommitHash() {
        return this.myCommitHash;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public String toString() {
        return String.format("%s:%s(%s|%s)", this.myRoot.getName(), this.myName, this.myCommitHash, this.myType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRefImpl ref = (VcsRefImpl)o;
        if (!this.myCommitHash.equals(ref.myCommitHash)) {
            return false;
        }
        if (!this.myName.equals(ref.myName)) {
            return false;
        }
        if (!this.myRoot.equals(ref.myRoot)) {
            return false;
        }
        return this.myType == ref.myType;
    }

    public int hashCode() {
        int result2 = this.myCommitHash.hashCode();
        result2 = 31 * result2 + this.myName.hashCode();
        result2 = 31 * result2 + this.myRoot.hashCode();
        result2 = 31 * result2 + this.myType.hashCode();
        return result2;
    }
}

