/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class VcsUserImpl
implements VcsUser {
    @NotNull
    private final String myName;
    @NotNull
    private final String myEmail;

    public VcsUserImpl(@NotNull String name, @NotNull String email) {
        this.myName = name;
        this.myEmail = VcsUserUtil.emailToLowerCase(email);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getEmail() {
        return this.myEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsUserImpl user = (VcsUserImpl)o;
        if (!this.myName.equals(user.myName)) {
            return false;
        }
        return this.myEmail.equals(user.myEmail);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myEmail);
    }

    public String toString() {
        return VcsUserUtil.toExactString(this);
    }
}

