/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogFeaturesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        VcsLogUiImpl ui;
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        if (projectLog != null && (ui = projectLog.getMainLogUi()) != null) {
            MainVcsLogUiProperties properties = ui.getProperties();
            VcsLogUiProperties defaultProperties = VcsLogFeaturesCollector.createDefaultPropertiesInstance();
            HashSet usages = ContainerUtil.newHashSet((Object[])new UsageDescriptor[]{new UsageDescriptor("uiInitialized")});
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "details", CommonUiProperties.SHOW_DETAILS);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "diffPreview", CommonUiProperties.SHOW_DIFF_PREVIEW);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "parentChanges", MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "onlyAffectedChanges", MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "long.edges", MainVcsLogUiProperties.SHOW_LONG_EDGES);
            VcsLogFeaturesCollector.addEnumUsage(properties, defaultProperties, usages, "sort", MainVcsLogUiProperties.BEK_SORT_TYPE);
            if (ui.getColorManager().isMultipleRoots()) {
                VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "roots", CommonUiProperties.SHOW_ROOT_NAMES);
            }
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "labels.compact", MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "labels.showTagNames", MainVcsLogUiProperties.SHOW_TAG_NAMES);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "textFilter.regex", MainVcsLogUiProperties.TEXT_FILTER_REGEX);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "textFilter.matchCase", MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE);
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)project)) {
                if (!factory.showMenuItem()) continue;
                VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "highlighter." + VcsLogFeaturesCollector.getFactoryIdSafe(factory), MainVcsLogUiProperties.VcsLogHighlighterProperty.get(factory.getId()));
            }
            for (VcsLogFilterCollection.FilterKey key : VcsLogFilterCollection.STANDARD_KEYS) {
                if (properties.getFilterValues(key.getName()) == null) continue;
                usages.add(StatisticsUtilKt.getBooleanUsage(key.getName() + "Filter", true));
            }
            List<String> tabs2 = projectLog.getTabsManager().getTabs();
            usages.add(StatisticsUtilKt.getCountingUsage("additionalTabs.count", tabs2.size(), Arrays.asList(0, 1, 2, 3, 4, 8)));
            return usages;
        }
        return Collections.emptySet();
    }

    @NotNull
    private static String getFactoryIdSafe(@NotNull VcsLogHighlighterFactory factory) {
        if (PluginInfoDetectorKt.getPluginInfo(factory.getClass()).isDevelopedByJetBrains()) {
            return UsageDescriptorKeyValidator.ensureProperKey(factory.getId());
        }
        return "THIRD_PARTY";
    }

    private static void addBooleanUsage(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull String usageName, @NotNull VcsLogUiProperties.VcsLogUiProperty<Boolean> property) {
        VcsLogFeaturesCollector.addUsageIfNotDefault(properties, defaultProperties, usages, property, value -> StatisticsUtilKt.getBooleanUsage(usageName, value));
    }

    private static void addEnumUsage(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull String usageName, @NotNull VcsLogUiProperties.VcsLogUiProperty<? extends Enum> property) {
        VcsLogFeaturesCollector.addUsageIfNotDefault(properties, defaultProperties, usages, property, value -> StatisticsUtilKt.getEnumUsage(usageName, value));
    }

    private static <T> void addUsageIfNotDefault(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull Function<? super T, ? extends UsageDescriptor> createUsage) {
        if (!properties.exists(property)) {
            return;
        }
        T value = properties.get(property);
        if (!Objects.equals(defaultProperties.get(property), value)) {
            usages.add((UsageDescriptor)createUsage.fun(value));
        }
    }

    @NotNull
    private static VcsLogUiProperties createDefaultPropertiesInstance() {
        return new VcsLogUiPropertiesImpl(new VcsLogApplicationSettings()){
            @NotNull
            private final VcsLogUiPropertiesImpl.State myState = new VcsLogUiPropertiesImpl.State();

            @Override
            @NotNull
            public VcsLogUiPropertiesImpl.State getState() {
                return this.myState;
            }

            @Override
            public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
                throw new UnsupportedOperationException();
            }

            public void loadState(@NotNull Object state) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "vcs.log.ui";
    }
}

