/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogRepoSizeCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        DataPack dataPack;
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogData logData = projectLog.getDataManager();
        if (logData != null && (dataPack = logData.getDataPack()).isFull()) {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            HashSet usages = ContainerUtil.newHashSet((Object[])new UsageDescriptor[]{new UsageDescriptor("dataInitialized")});
            usages.add(StatisticsUtilKt.getCountingUsage("commit.count", permanentGraph.getAllCommits().size(), Arrays.asList(0, 1, 100, 1000, 10000, 100000, 500000, 1000000)));
            usages.add(StatisticsUtilKt.getCountingUsage("branches.count", dataPack.getRefsModel().getBranches().size(), Arrays.asList(0, 1, 10, 50, 100, 500, 1000, 5000, 10000, 20000, 50000)));
            usages.add(StatisticsUtilKt.getCountingUsage("users.count", logData.getAllUsers().size(), Arrays.asList(0, 1, 10, 50, 100, 500, 1000, 5000, 10000, 20000, 50000)));
            for (VcsKey vcs : groupedRoots.keySet()) {
                String vcsKey = VcsLogRepoSizeCollector.getVcsKeySafe(vcs);
                usages.add(StatisticsUtilKt.getCountingUsage(vcsKey + ".root.count", groupedRoots.get((Object)vcs).size(), Arrays.asList(0, 1, 2, 5, 8, 15, 30, 50, 100, 300, 500)));
            }
            return usages;
        }
        return Collections.emptySet();
    }

    @NotNull
    private static String getVcsKeySafe(@NotNull VcsKey vcs) {
        if (PluginInfoDetectorKt.getPluginInfo(vcs.getClass()).isDevelopedByJetBrains()) {
            return UsageDescriptorKeyValidator.ensureProperKey(vcs.getName().toLowerCase());
        }
        return "third.party";
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        MultiMap result2 = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result2.putValue((Object)vcs, (Object)root);
        }
        return result2;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "vcs.log.data";
    }
}

