/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import org.jetbrains.annotations.NotNull;

public class VcsLogUsageTriggerCollector {
    public static void triggerUsage(@NotNull AnActionEvent e, @NotNull Object action) {
        String name = action.getClass().getName();
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, name);
    }

    public static void triggerUsage(@NotNull AnActionEvent e, @NotNull String text) {
        VcsLogUsageTriggerCollector.triggerUsage(text, e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null);
    }

    public static void triggerUsage(@NotNull String text) {
        VcsLogUsageTriggerCollector.triggerUsage(text, "");
    }

    public static void triggerUsage(@NotNull String text, boolean isFromHistory) {
        VcsLogUsageTriggerCollector.triggerUsage(text, isFromHistory ? "history." : "log.");
    }

    private static void triggerUsage(@NotNull String text, @NotNull String prefix) {
        String feature = prefix + UsageDescriptorKeyValidator.ensureProperKey(text);
        FUCounterUsageLogger.getInstance().logEvent("vcs.log.trigger", feature);
    }
}

