/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.navigation.History;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsLogUi
implements VcsLogUi,
Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final String myId;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        this.myId = id;
        this.myProject = logData.getProject();
        this.myLogData = logData;
        this.myRefresher = refresher;
        this.myColorManager = manager;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public void requestFocus() {
        VcsLogGraphTable graphTable = this.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(() -> graphTable.setRowSelectionInterval(0, 0));
        }
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    public void jumpToNearestCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        this.jumpTo(hash, (model, h) -> {
            if (!this.myLogData.getStorage().containsCommit(new CommitId(h, root))) {
                return -1;
            }
            int commitIndex = this.myLogData.getCommitIndex((Hash)h, root);
            Integer rowIndex = this.myVisiblePack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
            if (rowIndex == null) {
                rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, this.myVisiblePack);
            }
            return rowIndex == null ? -2 : rowIndex;
        }, (SettableFuture<? super Boolean>)SettableFuture.create());
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @NotNull
    public abstract VcsLogGraphTable getTable();

    @NotNull
    public abstract Component getMainComponent();

    @NotNull
    public abstract VcsLogUiProperties getProperties();

    @Nullable
    public abstract History getNavigationHistory();

    @Nullable
    public abstract String getHelpId();

    @NotNull
    public VisiblePackRefresher getRefresher() {
        return this.myRefresher;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        return this.myColorManager;
    }

    @NotNull
    public VcsLog getVcsLog() {
        return this.myLog;
    }

    @NotNull
    public VcsLogData getLogData() {
        return this.myLogData;
    }

    public void requestMore(@NotNull Runnable onLoaded) {
        this.myRefresher.moreCommitsNeeded(onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myVisiblePack;
    }

    public void jumpToRow(int row2) {
        this.jumpTo(row2, (model, r) -> {
            if (model.getRowCount() <= r) {
                return -1;
            }
            return r;
        }, (SettableFuture<? super Boolean>)SettableFuture.create());
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        SettableFuture future2 = SettableFuture.create();
        this.jumpToCommit(commitHash, root, (SettableFuture<? super Boolean>)future2);
        return future2;
    }

    public void jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root, @NotNull SettableFuture<? super Boolean> future2) {
        this.jumpTo(commitHash, (model, hash) -> model.getRowOfCommit((Hash)hash, root), future2);
    }

    public void jumpToCommitByPartOfHash(@NotNull String commitHash, @NotNull SettableFuture<? super Boolean> future2) {
        if (!VcsLogUtil.HASH_REGEX.matcher(commitHash).matches()) {
            future2.set((Object)false);
            return;
        }
        this.jumpTo(commitHash, GraphTableModel::getRowOfCommitByPartOfHash, future2);
    }

    protected <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<? super Boolean> future2) {
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int result2 = (Integer)rowGetter.fun((Object)model, commitId);
        if (result2 >= 0) {
            this.getTable().jumpToRow(result2);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> this.jumpTo(commitId, rowGetter, future2));
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, future2));
        } else {
            this.handleCommitNotFound(commitId, result2 == -2, rowGetter);
            future2.set((Object)false);
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.WARNING, new NamedRunnable[0]);
    }

    @NotNull
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        return exists ? "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " doesn't match the filters" : "Commit " + AbstractVcsLogUi.getCommitPresentation(commitId) + " not found";
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        if (commitId instanceof Hash) {
            return ((Hash)commitId).toShortString();
        }
        if (commitId instanceof String) {
            return VcsLogUtil.getShortHash((String)commitId);
        }
        return commitId.toString();
    }

    protected void showWarningWithLink(@NotNull String mainText, @NotNull String linkText, final @NotNull Runnable onClick2) {
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, mainText, MessageType.WARNING, new NamedRunnable(linkText){

            public void run() {
                onClick2.run();
            }
        });
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    protected void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (VcsLogListener listener2 : this.myLogListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh2);
        }
    }

    public void invokeOnChange(@NotNull Runnable runnable2) {
        this.invokeOnChange(runnable2, (Condition<? super VcsLogDataPack>)Conditions.alwaysTrue());
    }

    protected void invokeOnChange(final @NotNull Runnable runnable2, final @NotNull Condition<? super VcsLogDataPack> condition) {
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (condition.value((Object)dataPack)) {
                    runnable2.run();
                    AbstractVcsLogUi.this.removeLogListener(this);
                }
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposing VcsLogUi '" + this.myId + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }
}

