/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.navigation.History;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends AbstractVcsLogUi {
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final History myHistory;
    @NotNull
    private final EventDispatcher<VcsLogFilterListener> myFilterListenerDispatcher = EventDispatcher.create(VcsLogFilterListener.class);

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection filters) {
        super(id, logData, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myMainFrame = new MainFrame(logData, this, uiProperties, this.myLog, this.myVisiblePack, filters);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    public MainFrame getMainFrame() {
        return this.myMainFrame;
    }

    private void performLongAction(@NotNull GraphAction graphAction, @NotNull String title) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GraphAnswer answer = this.myVisiblePack.getVisibleGraph().getActionController().performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                assert (updater != null) : "Action:" + title + "\nController: " + this.myVisiblePack.getVisibleGraph().getActionController() + "\nAnswer:" + answer;
                updater.run();
                this.getTable().handleAnswer((GraphAnswer<Integer>)answer);
            });
        }, title, false, null, this.getMainFrame().getMainComponent());
    }

    public void expandAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_EXPAND), "Expanding " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void collapseAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_COLLAPSE), "Collapsing " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    @Override
    protected <T> void handleCommitNotFound(final @NotNull T commitId, boolean commitExists, final @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId, commitExists, rowGetter);
            return;
        }
        ArrayList runnables = ContainerUtil.newArrayList();
        runnables.add(new NamedRunnable("View and Reset Filters"){

            public void run() {
                VcsLogUiImpl.this.getFilterUi().setFilter(null);
                VcsLogUiImpl.this.invokeOnChange(() -> VcsLogUiImpl.this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
            }
        });
        final VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        final VcsLogManager logManager = projectLog.getLogManager();
        if (logManager != null && logManager.getDataManager() == this.myLogData) {
            runnables.add(new NamedRunnable("View in New Tab"){

                public void run() {
                    VcsLogUiImpl ui = projectLog.getTabsManager().openAnotherLogTab(logManager, VcsLogFilterObject.collection(new VcsLogFilter[0]));
                    ui.invokeOnChange(() -> ui.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                }
            });
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsLogUiImpl.getCommitNotFoundMessage(commitId, true), MessageType.WARNING, runnables.toArray(new NamedRunnable[0]));
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id);
        return this.myUiProperties.exists(property) && this.myUiProperties.get(property) != false;
    }

    public void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        this.myRefresher.onFiltersChange(filters);
        ((VcsLogFilterListener)this.myFilterListenerDispatcher.getMulticaster()).onFiltersChanged();
    }

    public void addFilterListener(@NotNull VcsLogFilterListener listener2) {
        this.myFilterListenerDispatcher.addListener((EventListener)listener2);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        return this.myMainFrame.getMainComponent();
    }

    @NotNull
    public JComponent getToolbar() {
        return this.myMainFrame.getToolbar();
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myMainFrame.getFilterUi();
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        return this.myUiProperties;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    public static interface VcsLogFilterListener
    extends EventListener {
        public void onFiltersChanged();
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDiffPreview(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().rootColumnUpdated();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().onColumnOrderSettingChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().repaint();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            }
        }

        private void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }
    }
}

