/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/ui/actions/CompareRevisionsFromLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.vcs.log.impl"})
public final class CompareRevisionsFromLogAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        if (log2 == null || handler2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log2.getSelectedCommits();
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(commits.size() == 2 && Intrinsics.areEqual((Object)((CommitId)CollectionsKt.first((List)commits)).getRoot(), (Object)((CommitId)CollectionsKt.last((List)commits)).getRoot()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        List commits = log2.getSelectedCommits();
        if (commits.size() == 2) {
            VirtualFile root = ((CommitId)CollectionsKt.first((List)commits)).getRoot();
            handler2.showDiffForPaths(root, VcsLogUtil.getAffectedPaths(root, e), ((CommitId)commits.get(1)).getHash(), ((CommitId)commits.get(0)).getHash());
        }
    }
}

