/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.actions.GoToHashOrRefPopup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoToHashOrRefAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi ui = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        assert (ui instanceof AbstractVcsLogUi);
        AbstractVcsLogUi logUi = (AbstractVcsLogUi)ui;
        Set<VirtualFile> visibleRoots = VcsLogUtil.getVisibleRoots(logUi);
        GoToHashOrRefPopup popup2 = new GoToHashOrRefPopup(project, logUi.getDataPack().getRefs(), visibleRoots, (Function<? super String, ? extends Future>)((Function)arg_0 -> ((VcsLog)log2).jumpToReference(arg_0)), (Function<? super VcsRef, ? extends Future>)((Function)vcsRef -> logUi.jumpToCommit(vcsRef.getCommitHash(), vcsRef.getRoot())), logUi.getColorManager(), new VcsGoToRefComparator(logUi.getDataPack().getLogProviders()));
        popup2.show((JComponent)((Object)logUi.getTable()));
    }

    public void update(@NotNull AnActionEvent e) {
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && log2 != null && logUi instanceof AbstractVcsLogUi);
    }
}

