/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import org.jetbrains.annotations.NotNull;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super("Open Another Log Tab", "Open Another Log Tab", AllIcons.Actions.OpenNewTab);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && projectLog.getLogManager() == logManager);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsProjectLog.getInstance(project).getTabsManager().openAnotherLogTab((VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER));
    }
}

