/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import org.jetbrains.annotations.NotNull;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super("Refresh", "Check for new commits and refresh Log if necessary", AllIcons.Actions.Refresh);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VisiblePackRefresher refresher;
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi ui = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui instanceof AbstractVcsLogUi && !(refresher = ((AbstractVcsLogUi)ui).getRefresher()).isValid()) {
            String message = "Trying to refresh invalid log tab.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
            refresher.setValid(true, false);
        }
        logManager.getDataManager().refreshSoftly(VcsLogUtil.getVisibleRoots(ui));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }
}

