/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.util.VcsLogUtil;
import org.jetbrains.annotations.NotNull;

public class ShowOnlyAffectedChangesAction
extends BooleanPropertyToggleAction {
    public ShowOnlyAffectedChangesAction() {
        super("Show Only Affected Changes", "Show only changes that affect files that were selected in the \"Paths\" menu", AllIcons.Nodes.Folder);
    }

    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (!VcsLogUtil.isFolderHistoryShownInLog()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Boolean hasAffectedFiles = (Boolean)e.getData(VcsLogChangesBrowser.HAS_AFFECTED_FILES);
        if (hasAffectedFiles == null || !hasAffectedFiles.booleanValue()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }
}

