/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.ui.actions.history.FileHistoryMetadataAction;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateRevisionFromHistoryAction
extends FileHistoryMetadataAction {
    @Override
    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsCommitMetadata detail, @NotNull AnActionEvent e) {
        VcsKey key = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (key == null) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.findVcsByKey((Project)((Project)ObjectUtils.notNull((Object)e.getProject())), (VcsKey)key);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider provider = vcs.getAnnotationProvider();
        if (provider == null) {
            return false;
        }
        if (detail != null) {
            VcsFileRevision fileRevision = ui.createRevision(detail);
            return AnnotateRevisionActionBase.isEnabled(vcs, FileHistoryUtil.createVcsVirtualFile(fileRevision), fileRevision);
        }
        return true;
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull FileHistoryUi ui, @NotNull VcsCommitMetadata detail, @NotNull AnActionEvent e) {
        VcsKey vcsKey = (VcsKey)e.getRequiredData(VcsDataKeys.VCS);
        VcsFileRevision revision = ui.createRevision(detail);
        VirtualFile vcsVirtualFile = FileHistoryUtil.createVcsVirtualFile(revision);
        if (!VcsHistoryUtil.isEmpty(revision) && vcsVirtualFile != null) {
            AnnotateRevisionActionBase.annotate(vcsVirtualFile, revision, (AbstractVcs)ObjectUtils.notNull((Object)VcsUtil.findVcsByKey((Project)project, (VcsKey)vcsKey)), null, 0);
        }
    }
}

