/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFolderHistoryActionProvider;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFolderHistoryActionProvider;", "Lcom/intellij/openapi/actionSystem/AnActionExtensionProvider;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "isActive", "", "update", "Companion", "intellij.platform.vcs.log.impl"})
public final class CompareRevisionsFromFolderHistoryActionProvider
implements AnActionExtensionProvider {
    private static final String COMPARE_TEXT = "Compare";
    private static final String COMPARE_DESCRIPTION = "Compare selected versions";
    private static final String DIFF_TEXT = "Show Diff";
    private static final String DIFF_DESCRIPTION = "Show diff with previous version";
    public static final Companion Companion = new Companion(null);

    private final FilePath getFilePath(AnActionEvent e) {
        return (FilePath)e.getData(VcsDataKeys.FILE_PATH);
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) == null) {
            return false;
        }
        FilePath filePath = this.getFilePath(e);
        return filePath != null && filePath.isDirectory();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLogData logData = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        FilePath filePath = this.getFilePath(e);
        if (log2 == null || project == null || logData == null || filePath == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Companion.updateActionText(e, log2);
        e.getPresentation().setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(true);
            return;
        }
        if (log2.getSelectedCommits().size() >= 2) {
            VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
            e.getPresentation().setEnabledAndVisible(handler2 != null);
        } else {
            Collection collection = log2.getSelectedCommits();
            Presentation presentation = e.getPresentation();
            boolean bl = !collection.isEmpty();
            presentation.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogData logData = (VcsLogData)e.getRequiredData(VcsLogInternalDataKeys.LOG_DATA);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        FilePath filePath = this.getFilePath(e);
        if (filePath == null) {
            Intrinsics.throwNpe();
        }
        FilePath filePath2 = filePath;
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        List commits = log2.getSelectedCommits();
        if (commits.size() >= 2) {
            VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
            handler2.showDiff(((CommitId)commits.get(1)).getRoot(), filePath2, ((CommitId)commits.get(1)).getHash(), filePath2, ((CommitId)commits.get(0)).getHash());
            return;
        }
        List commitIds2 = ContainerUtil.map((Collection)commits, (Function)new Function<T, V>(logData){
            final /* synthetic */ VcsLogData $logData;

            public final int fun(CommitId c) {
                return this.$logData.getCommitIndex(c.getHash(), c.getRoot());
            }
            {
                this.$logData = vcsLogData;
            }
        });
        logData.getCommitDetailsGetter().loadCommitsData(commitIds2, (Consumer)new Consumer<List<VcsFullCommitDetails>>(filePath2, project){
            final /* synthetic */ FilePath $filePath;
            final /* synthetic */ Project $project;

            public final void consume(List<VcsFullCommitDetails> details) {
                VcsFullCommitDetails detail = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(details));
                List<Change> changes2 = FileHistoryUtil.collectRelevantChanges(detail, (Condition<? super Change>)((Condition)new Condition<Change>(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final boolean value(Change change) {
                        return FileHistoryUtil.affectsDirectory(change, this.this$0.$filePath);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                VcsDiffUtil.showChangesDialog(this.$project, "Changes in " + ((Hash)detail.getId()).toShortString() + " for " + this.$filePath.getName(), ContainerUtil.newArrayList((Iterable)changes2));
            }
            {
                this.$filePath = filePath;
                this.$project = project;
            }
        }, (Consumer)new Consumer<Throwable>(project){
            final /* synthetic */ Project $project;

            public final void consume(Throwable t) {
                VcsBalloonProblemNotifier.showOverChangesView(this.$project, "Could not load selected commits: " + t.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
            {
                this.$project = project;
            }
        }, (ProgressIndicator)null);
    }

    @JvmStatic
    public static final void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLog log2) {
        Companion.updateActionText(e, log2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFolderHistoryActionProvider$Companion;", "", "()V", "COMPARE_DESCRIPTION", "", "COMPARE_TEXT", "DIFF_DESCRIPTION", "DIFF_TEXT", "updateActionText", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "log", "Lcom/intellij/vcs/log/VcsLog;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        public final void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLog log2) {
            if (log2.getSelectedCommits().size() >= 2) {
                e.getPresentation().setText(CompareRevisionsFromFolderHistoryActionProvider.COMPARE_TEXT);
                e.getPresentation().setDescription(CompareRevisionsFromFolderHistoryActionProvider.COMPARE_DESCRIPTION);
            } else {
                e.getPresentation().setText(CompareRevisionsFromFolderHistoryActionProvider.DIFF_TEXT);
                e.getPresentation().setDescription(CompareRevisionsFromFolderHistoryActionProvider.DIFF_DESCRIPTION);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

