/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.ui.actions.history.FileHistorySingleCommitAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAllAffectedFromHistoryAction
extends FileHistorySingleCommitAction<VcsFullCommitDetails> {
    @Override
    @NotNull
    protected List<VcsFullCommitDetails> getSelection(@NotNull FileHistoryUi ui) {
        return ui.getVcsLog().getSelectedDetails();
    }

    @Override
    @NotNull
    protected DataGetter<VcsFullCommitDetails> getDetailsGetter(@NotNull FileHistoryUi ui) {
        return ui.getLogData().getCommitDetailsGetter();
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull FileHistoryUi ui, @NotNull VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        VirtualFile file2 = FileHistoryUtil.createVcsVirtualFile(ui.createRevision((VcsCommitMetadata)detail));
        AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser((CommittedChangeList)VcsLogUtil.createCommittedChangeList(detail), file2, "Paths affected by commit " + ((Hash)detail.getId()).toShortString());
    }
}

