/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowDiffAfterWithLocalFromFileHistoryActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null && e.getData(ChangesBrowserBase.DATA_KEY) == null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List commits = log2.getSelectedCommits();
        if (commits.size() != 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        e.getPresentation().setEnabled(filePath != null && filePath.getVirtualFile() != null && handler2 != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        List commits = log2.getSelectedCommits();
        if (commits.size() != 1) {
            return;
        }
        CommitId commit2 = (CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        FilePath localPath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        FilePath pathInCommit = ((FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI)).getPathInCommit(commit2.getHash());
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        handler2.showDiffWithLocal(commit2.getRoot(), pathInCommit, commit2.getHash(), localPath);
    }
}

