/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.vcs.ui.PopupListElementRendererWithIcon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.BranchLogSpeedSearchPopup;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.visible.filters.FilterPair;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter>, VcsLogClassicFilterUi.BranchFilterModel> {
    public static final String BRANCH_FILTER_NAME = "Branch";
    private final VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        super(BRANCH_FILTER_NAME, uiProperties, filterModel);
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter> filter) {
        return ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getFilterPresentation(filter);
    }

    @Override
    @Nullable
    protected FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter> createFilter(@NotNull List<String> values) {
        return ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).createFilterFromPresentation(values);
    }

    @Override
    protected boolean supportsNegativeValues() {
        return true;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        return new MyBranchLogSpeedSearchPopup();
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        actionGroup.add((AnAction)new MyBranchPopupBuilder(((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack(), this.myBranchFilterModel.getVisibleRoots(), this.getRecentValuesFromSettings()).build());
        return actionGroup;
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        Collection branches = ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack().getRefs().getBranches();
        if (this.myBranchFilterModel.getVisibleRoots() != null) {
            branches = ContainerUtil.filter((Collection)branches, branch -> this.myBranchFilterModel.getVisibleRoots().contains(branch.getRoot()));
        }
        return ContainerUtil.map((Collection)branches, VcsRef::getName);
    }

    private class MyBranchLogSpeedSearchPopup
    extends BranchLogSpeedSearchPopup {
        private PopupListElementRendererWithIcon myListElementRenderer;

        MyBranchLogSpeedSearchPopup() {
            super(BranchFilterPopupComponent.this.createActionGroup(), DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this));
        }

        protected MyBranchLogSpeedSearchPopup(@NotNull WizardPopup parent, @Nullable ListPopupStep step, Object value) {
            super(parent, step, DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this), value);
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            MyBranchPopupBuilder.BranchFilterAction branchAction = MyBranchLogSpeedSearchPopup.getSpecificAction(this.getList().getSelectedValue(), MyBranchPopupBuilder.BranchFilterAction.class);
            if (branchAction != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
                branchAction.toggle();
                this.getList().repaint();
            } else {
                super.handleSelect(handleFinalChoices, e);
            }
        }

        @Override
        protected PopupListElementRendererWithIcon getListElementRenderer() {
            if (this.myListElementRenderer == null) {
                this.myListElementRenderer = new PopupListElementRendererWithIcon(this);
            }
            return this.myListElementRenderer;
        }

        @Override
        protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
            if (step instanceof ListPopupStep) {
                return new MyBranchLogSpeedSearchPopup(parent, (ListPopupStep)step, parentValue);
            }
            return super.createPopup(parent, step, parentValue);
        }
    }

    private class MyBranchPopupBuilder
    extends BranchPopupBuilder {
        protected MyBranchPopupBuilder(@Nullable VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, List<? extends List<String>> recentItems) {
            super(dataPack, visibleRoots, recentItems);
        }

        @Override
        @NotNull
        public AnAction createAction(@NotNull String name, @NotNull Collection<? extends VcsRef> refs) {
            return new BranchFilterAction(name, refs);
        }

        @Override
        protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItems) {
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction((MultipleValueFilterPopupComponent)BranchFilterPopupComponent.this, recentItems));
        }

        @Override
        @NotNull
        protected AnAction createCollapsedAction(@NotNull String actionName, @NotNull Collection<? extends VcsRef> refs) {
            return new BranchFilterAction(actionName, refs);
        }

        @Override
        protected void createFavoritesAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> favorites) {
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, "Favorites", favorites, false));
        }

        private class BranchFilterAction
        extends MultipleValueFilterPopupComponent.PredefinedValueAction {
            @NotNull
            private final LayeredIcon myIcon;
            @NotNull
            private final LayeredIcon myHoveredIcon;
            @NotNull
            private final Collection<? extends VcsRef> myReferences;
            private boolean myIsFavorite;

            BranchFilterAction(@NotNull String value, Collection<? extends VcsRef> references) {
                super((MultipleValueFilterPopupComponent)BranchFilterPopupComponent.this, value);
                this.myReferences = references;
                this.myIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, EmptyIcon.ICON_16});
                this.myHoveredIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover});
                this.getTemplatePresentation().setIcon((Icon)this.myIcon);
                this.getTemplatePresentation().setSelectedIcon((Icon)this.myHoveredIcon);
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            private boolean isFavorite() {
                for (VcsRef vcsRef : this.myReferences) {
                    if (!((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().isFavorite(vcsRef)) continue;
                    return true;
                }
                return false;
            }

            private void updateIcons() {
                this.myIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
            }

            public void setFavorite(boolean favorite) {
                for (VcsRef vcsRef : this.myReferences) {
                    ((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().setFavorite(vcsRef, favorite);
                }
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            public void toggle() {
                this.setFavorite(!this.myIsFavorite);
            }
        }
    }
}

