/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    protected final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<VirtualFile> myVisibleRoots;
    @Nullable
    private final List<? extends List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull String var1, @NotNull Collection<? extends VcsRef> var2);

    protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
        assert (this.myRecentItems == null);
    }

    protected void createFavoritesAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> favorites) {
    }

    @NotNull
    protected AnAction createCollapsedAction(@NotNull String actionName, @NotNull Collection<? extends VcsRef> refs) {
        return this.createAction(actionName, refs);
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        Groups filteredGroups = new Groups();
        Collection allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = entry.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            List refGroups = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getReferenceManager().groupForBranchFilter((Collection)entry.getValue());
            BranchPopupBuilder.putActionsForReferences(dataPack, refGroups, filteredGroups);
        }
        if (recentItems != null) {
            filteredGroups.recentGroups.addAll(recentItems);
        }
        return filteredGroups;
    }

    @NotNull
    private DefaultActionGroup createActions(@NotNull Groups groups) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (Map.Entry entry : groups.singletonGroups.entrySet()) {
            actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
        }
        if (!groups.recentGroups.isEmpty()) {
            DefaultActionGroup recentGroup = new DefaultActionGroup("Recent", true);
            for (Object recentItem : groups.recentGroups) {
                this.createRecentAction(recentGroup, (List<String>)recentItem);
            }
            actionGroup.add((AnAction)recentGroup);
        }
        if (groups.favoriteGroups.size() > 1) {
            this.createFavoritesAction(actionGroup, ContainerUtil.newArrayList(groups.favoriteGroups.keySet()));
        }
        for (Map.Entry entry : groups.favoriteGroups.entrySet()) {
            actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
        }
        for (Map.Entry group : groups.expandedGroups.entrySet()) {
            actionGroup.addSeparator((String)group.getKey());
            for (Map.Entry entry : ((TreeMap)group.getValue()).entrySet()) {
                actionGroup.add(this.createAction((String)entry.getKey(), (Collection)entry.getValue()));
            }
        }
        actionGroup.addSeparator();
        for (Map.Entry group : groups.collapsedGroups.entrySet()) {
            DefaultActionGroup popupGroup = new DefaultActionGroup((String)group.getKey(), true);
            for (Map.Entry entry : ((TreeMap)group.getValue()).entrySet()) {
                popupGroup.add(this.createCollapsedAction((String)entry.getKey(), (Collection)entry.getValue()));
            }
            actionGroup.add((AnAction)popupGroup);
        }
        return actionGroup;
    }

    private static void putActionsForReferences(@NotNull VcsLogDataPack pack, @NotNull List<? extends RefGroup> references, @NotNull Groups actions) {
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                VcsRef ref = ((SingletonRefGroup)refGroup).getRef();
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions.favoriteGroups, refGroup.getName(), ref);
                    continue;
                }
                BranchPopupBuilder.append(actions.singletonGroups, refGroup.getName(), ref);
                continue;
            }
            TreeMap groups = refGroup.isExpanded() ? actions.expandedGroups : actions.collapsedGroups;
            TreeMap groupActions = groups.computeIfAbsent(refGroup.getName(), key -> new TreeMap());
            for (VcsRef ref : refGroup.getRefs()) {
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions.favoriteGroups, ref.getName(), ref);
                }
                BranchPopupBuilder.append(groupActions, ref.getName(), ref);
            }
        }
    }

    public static boolean isFavorite(@NotNull VcsLogDataPack pack, @NotNull VcsRef ref) {
        return ((VcsLogProvider)pack.getLogProviders().get(ref.getRoot())).getReferenceManager().isFavorite(ref);
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key, @NotNull T value) {
        BranchPopupBuilder.append(map2, key, Collections.singleton(value));
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key, @NotNull Collection<? extends T> values) {
        map2.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    private static class Groups {
        private final TreeMap<String, Collection<VcsRef>> favoriteGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, Collection<VcsRef>> singletonGroups = ContainerUtil.newTreeMap();
        private final List<List<String>> recentGroups = ContainerUtil.newArrayList();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> expandedGroups = ContainerUtil.newTreeMap();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> collapsedGroups = ContainerUtil.newTreeMap();

        private Groups() {
        }
    }
}

