/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.google.common.primitives.Chars;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultilinePopupBuilder {
    private static final char[] SEPARATORS = new char[]{'|', '\n'};
    private static final String COMPLETION_ADVERTISEMENT = "Select one or more values separated with | or new lines";
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project, @NotNull Collection<String> values, @NotNull String initialValue, boolean supportsNegativeValues) {
        this.myTextField = MultilinePopupBuilder.createTextField(project, values, supportsNegativeValues, initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project, Collection<String> values, boolean supportsNegativeValues, @NotNull String initialValue) {
        TextFieldWithCompletion textField2 = new TextFieldWithCompletion(project, new MyCompletionProvider(values, supportsNegativeValues), initialValue, false, true, false){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                SoftWrapsEditorCustomization.ENABLED.customize(editor);
                return editor;
            }
        };
        textField2.setBorder(new CompoundBorder(JBUI.Borders.empty((int)2), textField2.getBorder()));
        return textField2;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)((Object)this.myTextField), "Center");
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)((Object)this.myTextField)).setCancelOnClickOutside(true).setAdText("Select one or more values separated with | or new lines, use " + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup2 = builder2.createPopup();
        popup2.setMinimumSize((Dimension)new JBDimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.unregisterCustomShortcutSet(popup2.getContent());
                popup2.closeOk(e.getInputEvent());
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup2.getContent());
        return popup2;
    }

    @NotNull
    List<String> getSelectedValues() {
        return ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), value -> {
            String trimmed = value.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
    }

    private static class MyCompletionProvider
    extends ValuesCompletionProvider.ValuesCompletionProviderDumbAware<String> {
        private final boolean mySupportsNegativeValues;

        MyCompletionProvider(@NotNull Collection<String> values, boolean supportsNegativeValues) {
            super(new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), Chars.asList((char[])SEPARATORS), values, false);
            this.mySupportsNegativeValues = supportsNegativeValues;
        }

        @Override
        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            String prefix = super.getPrefix(text, offset);
            if (this.mySupportsNegativeValues && prefix != null) {
                return StringUtil.trimLeading((String)prefix, (char)'-');
            }
            return prefix;
        }

        @Override
        @Nullable
        public String getAdvertisement() {
            return MultilinePopupBuilder.COMPLETION_ADVERTISEMENT;
        }
    }
}

