/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter, Model extends FilterModel<Filter>>
extends FilterPopupComponent<Filter, Model> {
    private static final int MAX_FILTER_VALUE_LENGTH = 20;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;

    MultipleValueFilterPopupComponent(@NotNull String filterName, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Model filterModel) {
        super(filterName, filterModel);
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        return this.myUiProperties.getRecentlyFilteredGroups(this.myName);
    }

    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        this.myUiProperties.addRecentlyFilteredGroup(this.myName, values);
    }

    @NotNull
    protected abstract List<String> getAllValues();

    @Nullable
    protected abstract Filter createFilter(@NotNull List<String> var1);

    @NotNull
    protected abstract List<String> getFilterValues(@NotNull Filter var1);

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.addSeparator("Recent");
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(recentGroup));
            }
            group.addSeparator();
        }
        return group;
    }

    @Override
    @NotNull
    protected String getText(@NotNull Filter filter) {
        return MultipleValueFilterPopupComponent.displayableText(this.getFilterValues(filter), 20);
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull Filter filter) {
        return MultipleValueFilterPopupComponent.tooltip(this.getFilterValues(filter));
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values, int maxLength) {
        String text = values.size() == 1 ? (String)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(values)) : StringUtil.join(values, (String)"|");
        return StringUtil.shortenTextWithEllipsis((String)text, (int)maxLength, (int)0, (boolean)true);
    }

    @NotNull
    static String tooltip(@NotNull Collection<String> values) {
        return StringUtil.join(values, (String)", ");
    }

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        return new SelectMultipleValuesAction();
    }

    protected boolean supportsNegativeValues() {
        return false;
    }

    @NotNull
    private static String getActionName(@NotNull List<String> values) {
        if (values.size() == 1) {
            return (String)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(values));
        }
        return MultipleValueFilterPopupComponent.displayableText(values, 40);
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super("Select...");
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Object filter = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            List<String> values = filter == null ? Collections.emptyList() : MultipleValueFilterPopupComponent.this.getFilterValues(filter);
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, this.myVariants, this.getPopupText(values), MultipleValueFilterPopupComponent.this.supportsNegativeValues());
            JBPopup popup2 = popupBuilder.createPopup();
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event.isOk()) {
                        List<String> selectedValues = popupBuilder.getSelectedValues();
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }
            });
            popup2.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            return selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
        }
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final List<String> myValues;
        private final boolean myAddToRecent;

        public PredefinedValueAction(String value) {
            this(Collections.singletonList(value));
        }

        public PredefinedValueAction(List<String> values) {
            this(MultipleValueFilterPopupComponent.getActionName(values), values, true);
        }

        public PredefinedValueAction(@NotNull String name, List<String> values, boolean addToRecent) {
            super(null, MultipleValueFilterPopupComponent.tooltip(values), null);
            this.getTemplatePresentation().setText(name, false);
            this.myValues = values;
            this.myAddToRecent = addToRecent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(this.myValues));
            if (this.myAddToRecent) {
                MultipleValueFilterPopupComponent.this.rememberValuesInSettings(this.myValues);
            }
        }
    }
}

