/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.FilterPair;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<FilterPair<VcsLogStructureFilter, VcsLogRootFilter>, FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter>> {
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    private static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    private static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;

    StructureFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> filterModel, @NotNull VcsLogColorManager colorManager) {
        super("Paths", filterModel);
        this.myUiProperties = uiProperties;
        this.myColorManager = colorManager;
    }

    private static VcsLogRootFilter getRootFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter2();
    }

    private static VcsLogStructureFilter getStructureFilter(@Nullable FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        if (filter == null) {
            return null;
        }
        return filter.getFilter1();
    }

    @NotNull
    private Collection<VirtualFile> getFilterRoots(@Nullable VcsLogRootFilter filter) {
        return filter != null ? filter.getRoots() : this.getAllRoots();
    }

    @NotNull
    private static Collection<FilePath> getFilterFiles(@Nullable VcsLogStructureFilter filter) {
        return filter != null ? filter.getFiles() : Collections.emptySet();
    }

    @Override
    @NotNull
    protected String getText(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter(filter);
        VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter(filter);
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), rootFilter, structureFilter);
        Collection<VirtualFile> roots = this.getFilterRoots(rootFilter);
        Collection<FilePath> files2 = StructureFilterPopupComponent.getFilterFiles(structureFilter);
        if (files2.isEmpty()) {
            return StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
        }
        return StructureFilterPopupComponent.getTextFromFilePaths(files2, "folders", false);
    }

    @NotNull
    private static String getTextFromRoots(@NotNull Collection<? extends VirtualFile> files2, boolean full) {
        return StructureFilterPopupComponent.getText(files2, "roots", FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
    }

    @NotNull
    private static String getTextFromFilePaths(@NotNull Collection<? extends FilePath> files2, @NotNull String category, boolean full) {
        return StructureFilterPopupComponent.getText(files2, category, FILE_PATH_BY_PATH_COMPARATOR, file2 -> StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
    }

    @NotNull
    private static <F> String getText(@NotNull Collection<? extends F> files2, @NotNull String category, @NotNull Comparator<? super F> comparator2, @NotNull NotNullFunction<? super F, String> getText2, boolean full) {
        if (full) {
            return "All";
        }
        if (files2.isEmpty()) {
            return "No " + category;
        }
        F firstFile = Collections.min(files2, comparator2);
        String firstFileName = (String)getText2.fun(firstFile);
        if (files2.size() == 1) {
            return firstFileName;
        }
        return firstFileName + " + " + (files2.size() - 1);
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull FilterPair<VcsLogStructureFilter, VcsLogRootFilter> filter) {
        return this.getToolTip(this.getFilterRoots(StructureFilterPopupComponent.getRootFilter(filter)), StructureFilterPopupComponent.getFilterFiles(StructureFilterPopupComponent.getStructureFilter(filter)));
    }

    @NotNull
    private String getToolTip(@NotNull Collection<? extends VirtualFile> roots, @NotNull Collection<? extends FilePath> files2) {
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + "No Roots Selected";
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + "Roots:\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots);
        }
        if (!files2.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + "Folders:\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files2);
        }
        return tooltip;
    }

    @NotNull
    private static String getTooltipTextForRoots(@NotNull Collection<? extends VirtualFile> files2) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_BY_NAME_COMPARATOR, VirtualFile::getName);
    }

    @NotNull
    private static String getTooltipTextForFilePaths(@NotNull Collection<? extends FilePath> files2) {
        return StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_PATH_BY_PATH_COMPARATOR, FilePath::getPresentableUrl);
    }

    @NotNull
    private static <F> String getTooltipTextForFiles(@NotNull Collection<? extends F> files2, @NotNull Comparator<? super F> comparator2, @NotNull NotNullFunction<? super F, String> getText2) {
        List filesToDisplay = ContainerUtil.sorted(files2, comparator2);
        filesToDisplay = ContainerUtil.getFirstItems((List)filesToDisplay, (int)10);
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText2, (String)"\n");
        if (files2.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        return tooltip;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.isMultipleRoots()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter : this.getRecentFilters()) {
            structureActions.add(new SelectFromHistoryAction(filter));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Recent"), new DefaultActionGroup(structureActions), new Separator("Roots"), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Roots"), new DefaultActionGroup(rootActions), new Separator("Recent"), new DefaultActionGroup(structureActions)});
    }

    @NotNull
    private List<VcsLogStructureFilter> getRecentFilters() {
        List<List<String>> filterValues = this.myUiProperties.getRecentlyFilteredGroups(this.myName);
        return ContainerUtil.map2List(filterValues, values -> VcsLogClassicFilterUi.FileFilterModel.createStructureFilter(values));
    }

    private Set<VirtualFile> getAllRoots() {
        return ((FilterModel.PairFilterModel)this.myFilterModel).getDataPack().getLogProviders().keySet();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((FilterModel.PairFilterModel)this.myFilterModel).getFilter());
        if (rootFilter != null) {
            return rootFilter.getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogRootFilter rootFilter = StructureFilterPopupComponent.getRootFilter((FilterPair)((FilterModel.PairFilterModel)this.myFilterModel).getFilter());
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        ((FilterModel.PairFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoots(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        ((FilterModel.PairFilterModel)this.myFilterModel).setFilter(new FilterPair<Object, VcsLogRootFilter>(null, VcsLogFilterObject.fromRoot(root)));
    }

    @NotNull
    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter) {
        return StructureFilterPopupComponent.getTextFromFilePaths(filter.getFiles(), "items", filter.getFiles().isEmpty());
    }

    private class SelectFromHistoryAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter) {
            super(StructureFilterPopupComponent.getStructureActionText(filter), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter.getFiles()).replace("\n", " "), null);
            this.myFilter = filter;
            this.myIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == this.myFilter;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        static final String STRUCTURE_FILTER_TEXT = "Select Folders...";

        SelectFoldersAction() {
            super(STRUCTURE_FILTER_TEXT);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getDataPack();
            VcsLogStructureFilter structureFilter = StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter());
            Collection<Object> files2 = structureFilter == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)structureFilter.getFiles(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project, "Select Files or Folders to Filter by", files2, new ArrayList<VirtualFile>(dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                VcsLogStructureFilter newFilter = VcsLogFilterObject.fromVirtualFiles(chooser.getSelectedFiles());
                ((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).setFilter(new FilterPair<VcsLogStructureFilter, Object>(newFilter, null));
                StructureFilterPopupComponent.this.myUiProperties.addRecentlyFilteredGroup(StructureFilterPopupComponent.this.myName, VcsLogClassicFilterUi.FileFilterModel.getFilterValues(newFilter));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private final int mySize;
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        CheckboxColorIcon(int size, @NotNull Color color) {
            super(size, color);
            this.mySize = size;
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, this.mySize, this.mySize);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        @NotNull
        public CheckboxColorIcon withIconPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withIconPreScaled(preScaled);
            return (CheckboxColorIcon)super.withIconPreScaled(preScaled);
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            super(root.getName(), root.getPresentableUrl(), null);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUI.scale((JBUI.JBIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            e.getPresentation().putClientProperty("ToolTipText", (Object)(KeyEvent.getKeyModifiersText(this.getMask()) + "+Click to see only \"" + e.getPresentation().getText() + "\""));
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.getStructureFilter((FilterPair)((FilterModel.PairFilterModel)StructureFilterPopupComponent.this.myFilterModel).getFilter()) == null;
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

