/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.FilterPair;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogUserFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel.SingleFilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FileFilterModel myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack, @Nullable VcsLogFilterCollection filters) {
        this.myUi = ui;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel((Computable<? extends VcsLogDataPack>)dataPackGetter, this.myLogData.getStorage(), this.myLogData.getRoots(), this.myUiProperties, filters);
        this.myUserFilterModel = new UserFilterModel((NotNullComputable<? extends VcsLogDataPack>)dataPackGetter, this.myUiProperties, filters);
        this.myDateFilterModel = new DateFilterModel((NotNullComputable<? extends VcsLogDataPack>)dataPackGetter, this.myUiProperties, filters);
        this.myStructureFilterModel = new FileFilterModel((NotNullComputable<VcsLogDataPack>)dataPackGetter, this.myLogData.getLogProviders().keySet(), this.myUiProperties, filters);
        this.myTextFilterModel = new TextFilterModel((NotNullComputable<? extends VcsLogDataPack>)dataPackGetter, this.myUiProperties, filters, ui);
        this.updateUiOnFilterChange();
        this.myUi.applyFiltersAndUpdateUi(this.getFilters());
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(() -> {
                this.myUi.applyFiltersAndUpdateUi(this.getFilters());
                this.myBranchFilterModel.onStructureFilterChanged(this.myStructureFilterModel.getRootFilter(), this.myStructureFilterModel.getStructureFilter());
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        this.myDataPack = dataPack;
    }

    @NotNull
    public SearchTextField createTextFilter() {
        return new TextFilterField(this.myTextFilterModel);
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new BranchFilterPopupComponent(this.myUiProperties, this.myBranchFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new DateFilterPopupComponent(this.myDateFilterModel).initUi())));
        actionGroup.add((AnAction)new FilterActionComponent((Computable<? extends JComponent>)((Computable)() -> new StructureFilterPopupComponent(this.myUiProperties, this.myStructureFilterModel, this.myUi.getColorManager()).initUi())));
        return actionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return VcsLogFilterObject.collection(new VcsLogFilter[]{this.myBranchFilterModel.getFilter1(), this.myBranchFilterModel.getFilter2(), this.myTextFilterModel.getFilter1(), this.myTextFilterModel.getFilter2(), this.myStructureFilterModel.getFilter1(), this.myStructureFilterModel.getFilter2(), (VcsLogFilter)this.myDateFilterModel.getFilter(), (VcsLogFilter)this.myUserFilterModel.getFilter()});
    }

    public void setFilter(@Nullable VcsLogFilter filter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter == null) {
            this.myBranchFilterModel.setFilter(null);
            this.myStructureFilterModel.setFilter(null);
            this.myDateFilterModel.setFilter(null);
            this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
            this.myUserFilterModel.setFilter(null);
        } else if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setBranchFilter((VcsLogBranchFilter)filter);
        } else if (filter instanceof VcsLogStructureFilter) {
            this.myStructureFilterModel.setStructureFilter((VcsLogStructureFilter)filter);
        }
        JComponent toolbar = this.myUi.getToolbar();
        toolbar.revalidate();
        toolbar.repaint();
    }

    private static class TextFilterField
    extends SearchTextField {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        TextFilterField(@NotNull TextFilterModel model) {
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter());
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    try {
                        myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                    }
                    catch (BadLocationException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            });
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter");
            if (!shortcutText.isEmpty()) {
                this.getTextEditor().setToolTipText("Use " + shortcutText + " to switch between text filter and commits list");
            }
        }

        protected void applyFilter() {
            this.myTextFilterModel.setFilterText(this.getText());
            this.addCurrentTextToHistory();
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
        }

        protected void onFocusLost() {
            if (this.myTextFilterModel.hasUnsavedChanges()) {
                this.applyFilter();
            }
        }
    }

    private class UserFilterModel
    extends FilterModel.SingleFilterModel<VcsLogUserFilter> {
        UserFilterModel(@NotNull NotNullComputable<? extends VcsLogDataPack> dataPackGetter, @Nullable MainVcsLogUiProperties uiProperties, VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.USER_FILTER, (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties, filters);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values) {
            return VcsLogFilterObject.fromUserNames(values, VcsLogClassicFilterUi.this.myLogData);
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter) {
            return ContainerUtil.newArrayList(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
        }
    }

    private static class DateFilterModel
    extends FilterModel.SingleFilterModel<VcsLogDateFilter> {
        DateFilterModel(@NotNull NotNullComputable<? extends VcsLogDataPack> dataPackGetter, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.DATE_FILTER, (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties, filters);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
            if (values.size() != 2) {
                LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
                return null;
            }
            String after = values.get(0);
            String before = values.get(1);
            try {
                return VcsLogFilterObject.fromDates(after.isEmpty() ? 0L : Long.parseLong(after), before.isEmpty() ? 0L : Long.parseLong(before));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
            Date after = filter.getAfter();
            Date before = filter.getBefore();
            return Arrays.asList(after == null ? "" : Long.toString(after.getTime()), before == null ? "" : Long.toString(before.getTime()));
        }
    }

    static class FileFilterModel
    extends FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> {
        @NotNull
        private static final String DIR = "dir:";
        @NotNull
        private static final String FILE = "file:";
        @NotNull
        private final Set<VirtualFile> myRoots;

        FileFilterModel(@NotNull NotNullComputable<VcsLogDataPack> dataPackGetter, @NotNull Set<VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.STRUCTURE_FILTER, VcsLogFilterCollection.ROOT_FILTER, (Computable<? extends VcsLogDataPack>)dataPackGetter, uiProperties, filters);
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogStructureFilter filter) {
            return FileFilterModel.getFilterValues(filter);
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogRootFilter filter) {
            return ContainerUtil.map((Collection)filter.getRoots(), VirtualFile::getPath);
        }

        @NotNull
        static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter) {
            return ContainerUtil.map((Collection)filter.getFiles(), path -> (path.isDirectory() ? DIR : FILE) + path.getPath());
        }

        @Override
        @NotNull
        protected VcsLogStructureFilter createFilter1(@NotNull List<String> values) {
            return FileFilterModel.createStructureFilter(values);
        }

        @Override
        @Nullable
        protected VcsLogRootFilter createFilter2(@NotNull List<String> values) {
            ArrayList selectedRoots = ContainerUtil.newArrayList();
            for (String path : values) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by file that does not exist " + path);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRoots(selectedRoots);
        }

        @Nullable
        protected VcsLogRootFilter getRootFilter() {
            return (VcsLogRootFilter)this.getFilter2();
        }

        @Nullable
        protected VcsLogStructureFilter getStructureFilter() {
            return (VcsLogStructureFilter)this.getFilter1();
        }

        protected void setStructureFilter(@NotNull VcsLogStructureFilter filter) {
            this.setFilter(new FilterPair<VcsLogStructureFilter, Object>(filter, null));
        }

        @NotNull
        static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            return VcsLogFilterObject.fromPaths(ContainerUtil.map(values, path -> {
                if (path.startsWith(DIR)) {
                    return VcsUtil.getFilePath((String)path.substring(DIR.length()), (boolean)true);
                }
                if (path.startsWith(FILE)) {
                    return VcsUtil.getFilePath((String)path.substring(FILE.length()), (boolean)false);
                }
                return VcsUtil.getFilePath((String)path);
            }));
        }
    }

    private static class TextFilterModel
    extends FilterModel.PairFilterModel<VcsLogTextFilter, VcsLogHashFilter> {
        @Nullable
        private String myText;

        TextFilterModel(@NotNull NotNullComputable<? extends VcsLogDataPack> dataPackProvider, @NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
            super(VcsLogFilterCollection.TEXT_FILTER, VcsLogFilterCollection.HASH_FILTER, (Computable<? extends VcsLogDataPack>)dataPackProvider, properties, filters);
            VcsLogUiProperties.PropertiesChangeListener listener2 = new VcsLogUiProperties.PropertiesChangeListener(){

                @Override
                public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                    if ((MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property)) && this.getFilter1() != null) {
                        myFilter = this.getFilterFromProperties();
                        this.notifyFiltersChanged();
                    }
                }
            };
            properties.addChangeListener(listener2);
            Disposer.register((Disposable)parentDisposable, () -> properties.removeChangeListener(listener2));
        }

        @Override
        @Nullable
        protected FilterPair<VcsLogTextFilter, VcsLogHashFilter> getFilterFromProperties() {
            Object filterPair = super.getFilterFromProperties();
            if (filterPair == null) {
                return null;
            }
            if (((FilterPair)filterPair).getFilter1() != null && !StringUtil.isEmptyOrSpaces((String)((VcsLogTextFilter)((FilterPair)filterPair).getFilter1()).getText())) {
                VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(((VcsLogTextFilter)((FilterPair)filterPair).getFilter1()).getText());
                if (!Objects.equals(((FilterPair)filterPair).getFilter2(), hashFilterFromText)) {
                    LOG.warn("Set hash filter " + ((FilterPair)filterPair).getFilter2() + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                    return new FilterPair<VcsLogTextFilter, VcsLogHashFilter>((VcsLogTextFilter)((FilterPair)filterPair).getFilter1(), hashFilterFromText);
                }
            } else if (((FilterPair)filterPair).getFilter2() != null && !((VcsLogHashFilter)((FilterPair)filterPair).getFilter2()).getHashes().isEmpty()) {
                VcsLogTextFilter textFilterFromHashes = this.createTextFilter(StringUtil.join((Collection)((VcsLogHashFilter)((FilterPair)filterPair).getFilter2()).getHashes(), (String)" "));
                LOG.warn("Set hash filter " + ((FilterPair)filterPair).getFilter2() + " is inconsistent with empty text filter. Using text filter " + textFilterFromHashes);
                return new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilterFromHashes, (VcsLogHashFilter)((FilterPair)filterPair).getFilter2());
            }
            return filterPair;
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                return this.myText;
            }
            if (this.getFilter1() != null) {
                return ((VcsLogTextFilter)this.getFilter1()).getText();
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            this.myText = text;
        }

        boolean hasUnsavedChanges() {
            if (this.myText == null) {
                return false;
            }
            return this.getFilter1() == null || !this.myText.equals(((VcsLogTextFilter)this.getFilter1()).getText());
        }

        @Override
        void setFilter(@Nullable FilterPair<VcsLogTextFilter, VcsLogHashFilter> filter) {
            super.setFilter(filter);
            this.myText = null;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogTextFilter filter) {
            return Collections.singletonList(filter.getText());
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogHashFilter filter) {
            return ContainerUtil.newArrayList((Iterable)filter.getHashes());
        }

        @Override
        @Nullable
        protected VcsLogTextFilter createFilter1(@NotNull List<String> values) {
            return this.createTextFilter((String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(values)));
        }

        @Override
        @Nullable
        protected VcsLogHashFilter createFilter2(@NotNull List<String> values) {
            return VcsLogFilterObject.fromHashes(values);
        }

        @NotNull
        private VcsLogTextFilter createTextFilter(@NotNull String text) {
            return VcsLogFilterObject.fromPattern(text, this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
        }

        public void setFilterText(@NotNull String text) {
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                this.setFilter((FilterPair<VcsLogTextFilter, VcsLogHashFilter>)null);
            } else {
                VcsLogTextFilter textFilter = this.createTextFilter(text);
                VcsLogHashFilter hashFilter = VcsLogFilterObject.fromHash(text);
                this.setFilter(new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter));
            }
        }
    }

    public static class BranchFilterModel
    extends FilterModel.PairFilterModel<VcsLogBranchFilter, VcsLogRevisionFilter> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<? extends VcsLogDataPack> provider, @NotNull VcsLogStorage storage2, @NotNull Collection<VirtualFile> roots, @NotNull MainVcsLogUiProperties properties, @Nullable VcsLogFilterCollection filters) {
            super(VcsLogFilterCollection.BRANCH_FILTER, VcsLogFilterCollection.REVISION_FILTER, provider, properties, filters);
            this.myStorage = storage2;
            this.myRoots = roots;
        }

        public void onStructureFilterChanged(@Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
            this.myVisibleRoots = rootFilter == null && structureFilter == null ? null : VcsLogUtil.getAllVisibleRoots(this.myRoots, rootFilter, structureFilter);
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @Override
        @Nullable
        protected VcsLogBranchFilter createFilter1(@NotNull List<String> values) {
            return VcsLogFilterObject.fromBranchPatterns(values, ContainerUtil.map2Set((Collection)this.getDataPack().getRefs().getBranches(), VcsRef::getName));
        }

        @Override
        @Nullable
        protected VcsLogRevisionFilter createFilter2(@NotNull List<String> values) {
            Pattern pattern = Pattern.compile("\\[(.*)\\](" + VcsLogUtil.HASH_REGEX.pattern() + ")");
            return VcsLogFilterObject.fromCommits(ContainerUtil.mapNotNull(values, s -> {
                Matcher matcher = pattern.matcher((CharSequence)s);
                if (!matcher.matches()) {
                    CommitId commitId;
                    if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher((CharSequence)s).matches() && (commitId = this.findCommitId(HashImpl.build(s))) != null) {
                        return commitId;
                    }
                    LOG.warn("Could not parse '" + s + "' while creating revision filter");
                    return null;
                }
                MatchResult result2 = matcher.toMatchResult();
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(result2.group(1));
                if (root == null) {
                    LOG.warn("Root '" + result2.group(1) + "' does not exist");
                    return null;
                }
                if (!this.myRoots.contains(root)) {
                    LOG.warn("Root '" + result2.group(1) + "' is not registered");
                    return null;
                }
                return new CommitId(HashImpl.build(result2.group(2)), root);
            }));
        }

        @Nullable
        private CommitId findCommitId(@NotNull Hash hash) {
            for (VirtualFile root : this.myRoots) {
                CommitId commitId = new CommitId(hash, root);
                if (!this.myStorage.containsCommit(commitId)) continue;
                return commitId;
            }
            return null;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogBranchFilter filter) {
            return ContainerUtil.newArrayList((Iterable)ContainerUtil.sorted((Collection)filter.getTextPresentation()));
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogRevisionFilter filter) {
            return ContainerUtil.map((Collection)filter.getHeads(), id -> "[" + id.getRoot().getPath() + "]" + id.getHash().asString());
        }

        @NotNull
        protected List<String> getFilter2Presentation(@NotNull VcsLogRevisionFilter filter) {
            return ContainerUtil.map((Collection)filter.getHeads(), id -> id.getHash().asString());
        }

        void setBranchFilter(@NotNull VcsLogBranchFilter filter) {
            this.setFilter(new FilterPair<VcsLogBranchFilter, Object>(filter, null));
        }

        @NotNull
        List<String> getFilterPresentation(@NotNull FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter> filter) {
            List branchFilterValues = filter.getFilter1() == null ? Collections.emptyList() : this.getFilter1Values(filter.getFilter1());
            List revisionFilterValues = filter.getFilter2() == null ? Collections.emptyList() : this.getFilter2Presentation(filter.getFilter2());
            return ContainerUtil.concat(branchFilterValues, revisionFilterValues);
        }

        @Nullable
        FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter> createFilterFromPresentation(@NotNull List<String> values) {
            ArrayList hashes = ContainerUtil.newArrayList();
            ArrayList branches = ContainerUtil.newArrayList();
            for (String s : values) {
                if (s.length() == 40 && VcsLogUtil.HASH_REGEX.matcher(s).matches()) {
                    hashes.add(s);
                    continue;
                }
                branches.add(s);
            }
            VcsLogBranchFilter branchFilter = branches.isEmpty() ? null : this.createFilter1((List<String>)branches);
            VcsLogRevisionFilter hashFilter = hashes.isEmpty() ? null : this.createFilter2((List<String>)hashes);
            return new FilterPair<VcsLogBranchFilter, VcsLogRevisionFilter>(branchFilter, hashFilter);
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<? extends JComponent> myComponentCreator;

        FilterActionComponent(@NotNull Computable<? extends JComponent> componentCreator) {
            this.myComponentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    }
}

