/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public abstract class VcsLogPopupComponent
extends JPanel {
    private static final int GAP_BEFORE_ARROW = 3;
    private static final int BORDER_SIZE = 2;
    @NotNull
    protected final String myName;
    @NotNull
    private JLabel myNameLabel;
    @NotNull
    private JLabel myValueLabel;

    protected VcsLogPopupComponent(@NotNull String name) {
        this.myName = name;
    }

    public JComponent initUi() {
        this.myNameLabel = new JLabel(this.myName + ": ");
        this.myValueLabel = new JLabel(){

            @Override
            public String getText() {
                return VcsLogPopupComponent.this.getCurrentText();
            }
        };
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(VcsLogPopupComponent.createUnfocusedBorder());
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myNameLabel);
        this.add(this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.installChangeListener(() -> {
            this.myValueLabel.revalidate();
            this.myValueLabel.repaint();
        });
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
        return this;
    }

    public abstract String getCurrentText();

    public abstract void installChangeListener(@NotNull Runnable var1);

    protected abstract ActionGroup createActionGroup();

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.createFocusedBorder());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.createUnfocusedBorder());
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    VcsLogPopupComponent.this.showPopupMenu();
                }
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                VcsLogPopupComponent.this.showPopupMenu();
                return true;
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                VcsLogPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                VcsLogPopupComponent.this.setDefaultForeground();
            }
        });
    }

    private void setDefaultForeground() {
        this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        this.myValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker());
    }

    private void setOnHoverForeground() {
        this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.myValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void showPopupMenu() {
        ListPopup popup2 = this.createPopupMenu();
        popup2.showUnderneathOf((Component)this);
    }

    @NotNull
    protected ListPopup createPopupMenu() {
        return JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    private static Border createFocusedBorder() {
        return BorderFactory.createCompoundBorder(new FilledRoundedBorder(UIUtil.getFocusedBorderColor(), 10, 2), JBUI.Borders.empty((int)2));
    }

    private static Border createUnfocusedBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), JBUI.Borders.empty((int)2));
    }

    private static class FilledRoundedBorder
    extends LineBorder {
        private final int myArcSize;

        FilledRoundedBorder(@NotNull Color color, int arcSize, int thickness) {
            super(color, thickness);
            this.myArcSize = arcSize;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.lineColor);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, this.myArcSize, this.myArcSize));
            int innerArc = Math.max(this.myArcSize - this.thickness, 0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + this.thickness, y + this.thickness, width - 2 * this.thickness, height - 2 * this.thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config2.restore();
        }
    }
}

