/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends JBPanel {
    public static final int SIDE_BORDER = 14;
    public static final int INTERNAL_BORDER = 10;
    public static final int EXTERNAL_BORDER = 14;
    private static final int ROOT_ICON_SIZE = 13;
    private static final int ROOT_GAP = 4;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final ReferencesPanel myBranchesPanel;
    @NotNull
    private final ReferencesPanel myTagsPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final HashAndAuthorPanel myHashAndAuthorPanel;
    @NotNull
    private final RootPanel myRootPanel;
    @NotNull
    private final BranchesPanel myContainingBranchesPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final Consumer<? super CommitId> myNavigate;
    @Nullable
    private CommitId myCommit;
    @Nullable
    private CommitPresentationUtil.CommitPresentation myPresentation;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<? super CommitId> navigate2) {
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myNavigate = navigate2;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.setOpaque(false);
        this.myMessagePanel = new MessagePanel();
        JBPanel metadataPanel = new JBPanel((LayoutManager)new BorderLayout(0, 0));
        this.myHashAndAuthorPanel = new HashAndAuthorPanel();
        this.myRootPanel = new RootPanel(this.myHashAndAuthorPanel);
        this.myBranchesPanel = new ReferencesPanel();
        this.myTagsPanel = new ReferencesPanel();
        this.myContainingBranchesPanel = new BranchesPanel();
        metadataPanel.setOpaque(false);
        this.myMessagePanel.setBorder((Border)JBUI.Borders.empty((int)14, (int)14, (int)10, (int)14));
        this.myHashAndAuthorPanel.setBorder((Border)JBUI.Borders.empty());
        metadataPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)14));
        this.myContainingBranchesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)14, (int)14, (int)14));
        this.add(this.myMessagePanel);
        metadataPanel.add((Component)((Object)this.myRootPanel), (Object)"West");
        metadataPanel.add((Component)this.myHashAndAuthorPanel, (Object)"Center");
        this.add((Component)metadataPanel);
        this.add(this.myBranchesPanel);
        this.add(this.myTagsPanel);
        this.add(this.myContainingBranchesPanel);
    }

    public void setCommit(@NotNull CommitId commit2, @NotNull CommitPresentationUtil.CommitPresentation presentation) {
        if (!commit2.equals((Object)this.myCommit) || presentation.isResolved()) {
            this.myCommit = commit2;
            this.myPresentation = presentation;
            this.myMessagePanel.update();
            this.myHashAndAuthorPanel.update();
            this.myRootPanel.setRoot(commit2.getRoot());
        }
        List<String> branches = this.myLogData.getContainingBranchesGetter().requestContainingBranches(commit2.getRoot(), commit2.getHash());
        this.myContainingBranchesPanel.setBranches(branches);
    }

    public void setRefs(@NotNull Collection<? extends VcsRef> refs) {
        List<VcsRef> references = this.sortRefs(refs);
        this.myBranchesPanel.setReferences(ContainerUtil.filter(references, ref -> ref.getType().isBranch()));
        this.myTagsPanel.setReferences(ContainerUtil.filter(references, ref -> !ref.getType().isBranch()));
        if (this.myTagsPanel.isVisible()) {
            this.myBranchesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)0, (int)14));
            this.myTagsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)10, (int)14));
        } else if (this.myBranchesPanel.isVisible()) {
            this.myBranchesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)10, (int)14));
        }
    }

    public void update() {
        this.myMessagePanel.update();
        this.myHashAndAuthorPanel.update();
        this.myRootPanel.update();
        this.myBranchesPanel.update();
        this.myTagsPanel.update();
        this.myContainingBranchesPanel.update();
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            ContainingBranchesGetter getter = this.myLogData.getContainingBranchesGetter();
            this.myContainingBranchesPanel.setBranches(getter.getContainingBranchesFromCache(this.myCommit.getRoot(), this.myCommit.getHash()));
        } else {
            this.myContainingBranchesPanel.setBranches(null);
        }
        this.myContainingBranchesPanel.update();
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Collection<? extends VcsRef> refs) {
        VcsRef ref = (VcsRef)ContainerUtil.getFirstItem(refs);
        if (ref == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
    }

    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    @NotNull
    public static Color getCommitDetailsBackground() {
        return UIUtil.getPanelBackground();
    }

    private class RootPanel
    extends Wrapper {
        private final JComponent myReferent;
        @Nullable
        private ColorIcon myIcon;
        @Nullable
        private String myTooltipText;

        RootPanel(JComponent component) {
            this.myReferent = component;
            this.setVerticalSizeReferent(this.myReferent);
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (IdeTooltipManager.getInstance().hasCurrent()) {
                        IdeTooltipManager.getInstance().hideCurrent(e);
                        return;
                    }
                    if (RootPanel.this.myIcon == null || RootPanel.this.myTooltipText == null) {
                        return;
                    }
                    VcsLogUiUtil.showTooltip((JComponent)((Object)RootPanel.this), new Point(RootPanel.this.myIcon.getIconWidth() / 2, 0), Balloon.Position.above, RootPanel.this.myTooltipText);
                }
            });
        }

        public Dimension getPreferredSize() {
            if (this.myIcon == null) {
                return new Dimension(0, 0);
            }
            Dimension size = super.getPreferredSize();
            return new Dimension(this.myIcon.getIconWidth() + JBUI.scale((int)4), size.height);
        }

        public void setRoot(@NotNull VirtualFile root) {
            if (CommitPanel.this.myColorManager.isMultipleRoots()) {
                JBColor color = VcsLogGraphTable.getRootBackgroundColor(root, CommitPanel.this.myColorManager);
                this.myIcon = (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(13, (Color)color));
                this.myTooltipText = root.getPath();
            } else {
                this.myIcon = null;
                this.myTooltipText = null;
            }
        }

        public void update() {
            this.setVisible(this.myIcon != null);
            this.revalidate();
            this.repaint();
        }

        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        protected void paintComponent(Graphics g) {
            if (this.myIcon != null) {
                int h = FontUtil.getStandardAscent(CommitPanel.this.myHashAndAuthorPanel.getBodyFont(), g);
                FontMetrics metrics = this.getFontMetrics(CommitPanel.this.myHashAndAuthorPanel.getBodyFont());
                this.myIcon.paintIcon((Component)((Object)this), g, 0, metrics.getMaxAscent() - h + (h - this.myIcon.getIconHeight() - 1) / 2);
            }
        }
    }

    private static class BranchesPanel
    extends HtmlPanel {
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded = false;

        private BranchesPanel() {
        }

        @Override
        public void reshape(int x, int y, int w, int h) {
            int oldWidth = this.getWidth();
            super.reshape(x, y, w, h);
            if (w != oldWidth) {
                this.update();
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "show-hide-branches".equals(e.getDescription())) {
                this.myExpanded = !this.myExpanded;
                this.update();
            }
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches;
            this.myExpanded = false;
            this.update();
        }

        @Override
        @NotNull
        protected String getBody() {
            Insets insets = this.getInsets();
            String text = CommitPresentationUtil.getBranchesText(this.myBranches, this.myExpanded, this.getWidth() - insets.left - insets.right, this.getFontMetrics(this.getBodyFont()));
            if (this.myExpanded) {
                return text;
            }
            return "<nobr>" + text + "</nobr>";
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        @NotNull
        protected Font getBodyFont() {
            return FontUtil.getCommitMetadataFont();
        }
    }

    private class HashAndAuthorPanel
    extends HtmlPanel {
        private HashAndAuthorPanel() {
        }

        @Override
        @NotNull
        protected String getBody() {
            return CommitPanel.this.myPresentation == null ? "" : CommitPanel.this.myPresentation.getHashAndAuthor();
        }

        @Override
        @NotNull
        protected Font getBodyFont() {
            return FontUtil.getCommitMetadataFont();
        }

        @Override
        public void update() {
            this.setVisible(CommitPanel.this.myPresentation != null);
            super.update();
        }
    }

    private class MessagePanel
    extends HtmlPanel {
        private MessagePanel() {
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription().startsWith("go-to-hash:")) {
                CommitId commitId = ((CommitPresentationUtil.CommitPresentation)ObjectUtils.notNull((Object)CommitPanel.this.myPresentation)).parseTargetCommit(e);
                if (commitId != null) {
                    CommitPanel.this.myNavigate.consume((Object)commitId);
                }
            } else {
                BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
            }
        }

        @Override
        @NotNull
        protected String getBody() {
            return CommitPanel.this.myPresentation == null ? "" : CommitPanel.this.myPresentation.getText();
        }

        @Override
        public Color getBackground() {
            if (this.hasPanelBackground()) {
                return CommitPanel.getCommitDetailsBackground();
            }
            return UIUtil.getTreeBackground();
        }

        @Override
        public void update() {
            this.setVisible(CommitPanel.this.myPresentation != null);
            this.setOpaque(!this.hasPanelBackground());
            super.update();
        }

        protected boolean hasPanelBackground() {
            return UIUtil.isUnderDarcula() || this.hasBackgroundImage();
        }

        private boolean hasBackgroundImage() {
            return !StringUtil.isEmpty((String)PropertiesComponent.getInstance().getValue("idea.background.editor")) || !StringUtil.isEmpty((String)PropertiesComponent.getInstance((Project)CommitPanel.this.myLogData.getProject()).getValue("idea.background.editor"));
        }
    }
}

