/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.codeInspection.ex.Tools;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import com.intellij.vcs.commit.SubjectLimitInspection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    static final String SHOW_HIDE_BRANCHES = "show-hide-branches";
    private static final String ELLIPSIS = "...";
    private static final int BIG_CUT_SIZE = 10;
    private static final double EPSILON = 1.5;

    @NotNull
    public static String getShortSummary(@NotNull VcsShortCommitDetails details) {
        return CommitPresentationUtil.getShortSummary(details, true, 50);
    }

    @NotNull
    public static String getShortSummary(@NotNull VcsShortCommitDetails details, boolean useHtml, int maxMessageLength) {
        return (useHtml ? "<b>" : "") + "\"" + StringUtil.shortenTextWithEllipsis((String)details.getSubject(), (int)maxMessageLength, (int)0, (String)ELLIPSIS) + "\"" + (useHtml ? "</b>" : "") + " by " + CommitPresentationUtil.getAuthorPresentation(details) + CommitPresentationUtil.formatDateTime(details.getAuthorTime());
    }

    @NotNull
    public static String getAuthorPresentation(@NotNull VcsShortCommitDetails details) {
        String authorString = VcsUserUtil.getShortPresentation(details.getAuthor());
        return authorString + (VcsUserUtil.isSamePerson(details.getAuthor(), details.getCommitter()) ? "" : "*");
    }

    @NotNull
    private static String escapeMultipleSpaces(@NotNull String text) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') {
                if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                    result2.append(' ');
                    continue;
                }
                result2.append("&nbsp;");
                continue;
            }
            result2.append(text.charAt(i));
        }
        return result2.toString();
    }

    @NotNull
    private static Set<String> findHashes(@NotNull String text) {
        HashSet result2 = ContainerUtil.newHashSet();
        Matcher matcher = HASH_PATTERN.matcher(text);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        return result2;
    }

    @NotNull
    private static String replaceHashes(@NotNull String s, @NotNull Set<String> resolvedHashes) {
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuffer result2 = new StringBuffer();
        while (matcher.find()) {
            String hash = matcher.group();
            if (resolvedHashes.contains(hash)) {
                hash = "<a href=\"go-to-hash:" + hash + "\">" + hash + "</a>";
            }
            matcher.appendReplacement(result2, hash);
        }
        matcher.appendTail(result2);
        return result2.toString();
    }

    @NotNull
    private static Set<String> findHashes(@NotNull Project project, @NotNull String message) {
        HashSet unresolvedHashes = ContainerUtil.newHashSet();
        IssueLinkHtmlRenderer.formatTextWithLinks(project, message, (Convertor<? super String, String>)((Convertor)s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        }));
        return unresolvedHashes;
    }

    @NotNull
    private static String formatCommitText(@NotNull Project project, @NotNull String fullMessage, @NotNull Set<String> resolvedHashes) {
        Font font = FontUtil.getCommitMessageFont();
        Convertor convertor = s -> CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        int separator = fullMessage.indexOf("\n\n");
        String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
        String description = fullMessage.substring(subject.length());
        if (subject.contains("\n")) {
            return CommitPresentationUtil.formatText(project, fullMessage, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        }
        if (CommitPresentationUtil.isSubjectMarginEnabled(project)) {
            int margin = CommitMessageInspectionProfile.getSubjectRightMargin(project);
            if ((double)subject.length() > (double)margin * 1.5) {
                int placeToCut;
                for (int i = placeToCut = margin - ELLIPSIS.length(); i >= Math.max(margin - 10, 10); --i) {
                    if (subject.charAt(i) != ' ') continue;
                    placeToCut = i;
                    break;
                }
                String tail = subject.substring(placeToCut);
                if (TrimUtil.isPunctuation((subject = subject.substring(0, placeToCut)).charAt(placeToCut - 1))) {
                    tail = StringUtil.trimStart((String)tail, (String)" ");
                } else {
                    subject = subject + ELLIPSIS;
                    tail = ELLIPSIS + tail;
                }
                description = "\n\n" + tail + description;
            }
        }
        return "<b>" + CommitPresentationUtil.formatText(project, subject, font, 1, (Convertor<? super String, String>)convertor) + "</b>" + CommitPresentationUtil.formatText(project, description, font, font.getStyle(), (Convertor<? super String, String>)convertor);
    }

    public static boolean isSubjectMarginEnabled(@NotNull Project project) {
        return CommitPresentationUtil.isInspectionEnabled(project, SubjectLimitInspection.class);
    }

    private static <T extends BaseCommitMessageInspection> boolean isInspectionEnabled(@NotNull Project project, @NotNull Class<T> inspectionClass) {
        BaseCommitMessageInspection inspection;
        CommitMessageInspectionProfile inspectionProfile = CommitMessageInspectionProfile.getInstance(project);
        List<Tools> tools = inspectionProfile.getAllEnabledInspectionTools(project);
        return ContainerUtil.find(tools, arg_0 -> CommitPresentationUtil.lambda$isInspectionEnabled$2(inspection = (BaseCommitMessageInspection)((Object)inspectionProfile.getTool(inspectionClass)), arg_0)) != null;
    }

    @NotNull
    private static String formatText(@NotNull Project project, @NotNull String text, @NotNull Font font, int style, @NotNull Convertor<? super String, String> convertor) {
        return FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project, text, convertor)), style, font);
    }

    @NotNull
    private static String getAuthorText(@NotNull VcsCommitMetadata commit2) {
        long authorTime = commit2.getAuthorTime();
        long commitTime = commit2.getCommitTime();
        String authorText = CommitPresentationUtil.getAuthorName(commit2.getAuthor()) + CommitPresentationUtil.formatDateTime(authorTime);
        if (!VcsUserUtil.isSamePerson(commit2.getAuthor(), commit2.getCommitter())) {
            String commitTimeText = authorTime != commitTime ? CommitPresentationUtil.formatDateTime(commitTime) : "";
            authorText = authorText + "<br/>" + CommitPresentationUtil.getCommitterText(commit2.getCommitter(), commitTimeText);
        } else if (authorTime != commitTime) {
            authorText = authorText + "<br/>" + CommitPresentationUtil.getCommitterText(null, CommitPresentationUtil.formatDateTime(commitTime));
        }
        return authorText;
    }

    @NotNull
    private static String getCommitterText(@Nullable VcsUser committer, @NotNull String commitTimeText) {
        String graySpan = "<span style='color:#" + ColorUtil.toHex((Color)JBColor.GRAY) + "'>";
        String text = graySpan + "committed";
        if (committer != null) {
            text = text + " by " + VcsUserUtil.getShortPresentation(committer);
            if (!committer.getEmail().isEmpty()) {
                text = text + "</span>" + CommitPresentationUtil.getEmailText(committer) + graySpan;
            }
        }
        text = text + commitTimeText + "</span>";
        return text;
    }

    @NotNull
    private static String getAuthorName(@NotNull VcsUser user) {
        String username = VcsUserUtil.getShortPresentation(user);
        return user.getEmail().isEmpty() ? username : username + CommitPresentationUtil.getEmailText(user);
    }

    @NotNull
    private static String getEmailText(@NotNull VcsUser user) {
        return " <a href='mailto:" + user.getEmail() + "'>&lt;" + user.getEmail() + "&gt;</a>";
    }

    @NotNull
    public static String formatDateTime(long time) {
        return " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
    }

    @NotNull
    private static String formatCommitHashAndAuthor(@NotNull VcsCommitMetadata commit2) {
        Font font = FontUtil.getCommitMetadataFont();
        return FontUtil.getHtmlWithFonts(((Hash)commit2.getId()).toShortString() + " " + CommitPresentationUtil.getAuthorText(commit2), font.getStyle(), font);
    }

    @NotNull
    static String getBranchesText(@Nullable List<String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        int tailWidth;
        if (branches == null) {
            return "In branches: loading...";
        }
        if (branches.isEmpty()) {
            return "Not in any branch";
        }
        String head = "In " + branches.size() + StringUtil.pluralize((String)" branch", (int)branches.size()) + ": ";
        if (expanded) {
            return head + "<a href=\"" + SHOW_HIDE_BRANCHES + "\">Hide</a><br/>" + StringUtil.join(branches, (String)"<br/>");
        }
        String tail = "\u2026 <a href=\"show-hide-branches\">Show all</a>";
        int headWidth = metrics.stringWidth(head);
        if (availableWidth <= headWidth + (tailWidth = metrics.stringWidth(StringUtil.removeHtmlTags((String)tail)))) {
            return head + tail;
        }
        availableWidth -= headWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i = 0; i < branches.size(); ++i) {
            String branch = branches.get(i) + (i != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth + tailWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) + tailWidth >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        return head + branchesText.toString();
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project, @NotNull VcsCommitMetadata commit2, @NotNull Set<? super String> unresolvedHashes) {
        String rawMessage = commit2.getFullMessage();
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit2);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project, rawMessage);
        if (unresolvedHashesForCommit.isEmpty()) {
            return new CommitPresentation(project, commit2.getRoot(), rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        return new UnresolvedPresentation(project, commit2.getRoot(), rawMessage, hashAndAuthor);
    }

    private static /* synthetic */ boolean lambda$isInspectionEnabled$2(BaseCommitMessageInspection inspection, Tools tool) {
        return tool.getTool().getTool().equals((Object)inspection);
    }

    public static class CommitPresentation {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final String myRawMessage;
        @NotNull
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        @NotNull
        private final MultiMap<String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rawMessage, @NotNull String hashAndAuthor, @NotNull MultiMap<String, CommitId> resolvedHashes) {
            this.myProject = project;
            this.myRoot = root;
            this.myRawMessage = rawMessage;
            this.myHashAndAuthor = hashAndAuthor;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        public String getText() {
            return CommitPresentationUtil.formatCommitText(this.myProject, this.myRawMessage, this.myResolvedHashes.keySet());
        }

        @NotNull
        public String getHashAndAuthor() {
            return this.myHashAndAuthor;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids = this.myResolvedHashes.get((Object)hash);
            if (ids.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
            }
            for (CommitId id : ids) {
                if (!this.myRoot.equals(id.getRoot())) continue;
                return id;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            return this;
        }

        public boolean isResolved() {
            return true;
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        UnresolvedPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rawMessage, @NotNull String hashAndAuthor) {
            super(project, root, rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            return new CommitPresentation(this.myProject, this.myRoot, this.myRawMessage, this.myHashAndAuthor, resolvedHashes);
        }

        @Override
        public boolean isResolved() {
            return false;
        }
    }
}

