/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsPanel
extends JPanel
implements EditorColorsListener,
Disposable {
    private static final int MAX_ROWS = 50;
    private static final int MIN_SIZE = 20;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JPanel myMainContentPanel;
    @NotNull
    private final StatusText myEmptyText;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private List<Integer> mySelection = ContainerUtil.emptyList();
    @NotNull
    private TIntHashSet myCommitIds = new TIntHashSet();
    @Nullable
    private ProgressIndicator myResolveIndicator = null;

    public DetailsPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parent) {
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.myScrollPane = new JBScrollPane(20, 31);
        this.myMainContentPanel = new MyMainContentPanel();
        this.myEmptyText = new StatusText(this.myMainContentPanel){

            protected boolean isStatusVisible() {
                return StringUtil.isNotEmpty((String)this.getText());
            }
        };
        this.myMainContentPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myMainContentPanel.setOpaque(false);
        this.myScrollPane.setViewportView(this.myMainContentPanel);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), parent, 300){

            public Color getBackground() {
                return CommitPanel.getCommitDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLoadingPanel, "Center");
        ProjectInspectionProfileManager.getInstance(logData.getProject()).addProfileChangeListener(new ProfileChangeAdapter(){

            public void profileChanged(@Nullable InspectionProfile profile2) {
                if (CommitMessageInspectionProfile.getInstance(DetailsPanel.this.myLogData.getProject()).equals(profile2)) {
                    ApplicationManager.getApplication().invokeLater(() -> DetailsPanel.this.update(), ModalityState.NON_MODAL);
                }
            }
        }, this);
        this.myEmptyText.setText("Commit details");
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void globalSchemeChange(EditorColorsScheme scheme2) {
        this.update();
    }

    private void update() {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.update();
        }
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public void installCommitSelectionListener(@NotNull VcsLogGraphTable graphTable) {
        graphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDetails(graphTable));
    }

    public void branchesChanged() {
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.updateBranches();
        }
    }

    protected void navigate(@NotNull CommitId commitId) {
    }

    private void rebuildCommitPanels(int[] selection) {
        this.myEmptyText.setText("");
        int selectionLength = selection.length;
        int existingCount = (this.myMainContentPanel.getComponentCount() + 1) / 2;
        int requiredCount = Math.min(selectionLength, 50);
        for (int i = existingCount; i < requiredCount; ++i) {
            if (i > 0) {
                this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            }
            this.myMainContentPanel.add((Component)((Object)new CommitPanel(this.myLogData, this.myColorManager, (Consumer<? super CommitId>)((Consumer)this::navigate))));
        }
        while (this.myMainContentPanel.getComponentCount() > 2 * requiredCount - 1) {
            this.myMainContentPanel.remove(this.myMainContentPanel.getComponentCount() - 1);
        }
        if (selectionLength > 50) {
            this.myMainContentPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            JBLabel label2 = new JBLabel("(showing 50 of " + selectionLength + " selected commits)");
            label2.setFont(FontUtil.getCommitMetadataFont());
            label2.setBorder((Border)JBUI.Borders.emptyLeft((int)14));
            this.myMainContentPanel.add((Component)label2);
        }
        this.mySelection = Ints.asList((int[])Arrays.copyOf(selection, requiredCount));
        this.repaint();
    }

    private void resolveHashes(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations, @NotNull Set<String> unResolvedHashes, @NotNull Condition<Object> expired) {
        if (!unResolvedHashes.isEmpty()) {
            this.myResolveIndicator = BackgroundTaskUtil.executeOnPooledThread(this, () -> {
                MultiMap resolvedHashes = MultiMap.createSmart();
                HashSet fullHashes = ContainerUtil.newHashSet((Iterable)ContainerUtil.filter((Collection)unResolvedHashes, h -> h.length() == 40));
                for (String fullHash : fullHashes) {
                    Hash hash = HashImpl.build(fullHash);
                    for (VirtualFile root : this.myLogData.getRoots()) {
                        CommitId id = new CommitId(hash, root);
                        if (!this.myLogData.getStorage().containsCommit(id)) continue;
                        resolvedHashes.putValue((Object)fullHash, (Object)id);
                    }
                }
                unResolvedHashes.removeAll(fullHashes);
                if (!unResolvedHashes.isEmpty()) {
                    this.myLogData.getStorage().iterateCommits((Function<? super CommitId, Boolean>)((Function)commitId -> {
                        for (String hashString : unResolvedHashes) {
                            if (!StringUtil.startsWithIgnoreCase((String)commitId.getHash().asString(), (String)hashString)) continue;
                            resolvedHashes.putValue((Object)hashString, commitId);
                        }
                        return false;
                    }));
                }
                List resolvedPresentations = ContainerUtil.map2List((Collection)presentations, presentation -> presentation.resolve((MultiMap<String, CommitId>)resolvedHashes));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myResolveIndicator = null;
                    this.setPresentations(ids, resolvedPresentations);
                }, Conditions.or(o -> this.myResolveIndicator != indicator, (Condition)expired));
            });
        }
    }

    private void cancelResolve() {
        if (this.myResolveIndicator != null) {
            this.myResolveIndicator.cancel();
            this.myResolveIndicator = null;
        }
    }

    private void setPresentations(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations) {
        assert (ids.size() == presentations.size());
        for (int i = 0; i < this.mySelection.size(); ++i) {
            CommitPanel commitPanel = this.getCommitPanel(i);
            commitPanel.setCommit(ids.get(i), presentations.get(i));
        }
    }

    @NotNull
    private CommitPanel getCommitPanel(int index) {
        return (CommitPanel)((Object)this.myMainContentPanel.getComponent(2 * index));
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.max(minimumSize.width, JBUI.scale((int)20)), Math.max(minimumSize.height, JBUI.scale((int)20)));
    }

    public void dispose() {
        this.cancelResolve();
    }

    private class MyMainContentPanel
    extends ScrollablePanel {
        private MyMainContentPanel() {
        }

        @Override
        public Insets getInsets() {
            return JBUI.emptyInsets();
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (StringUtil.isNotEmpty((String)DetailsPanel.this.myEmptyText.getText())) {
                DetailsPanel.this.myEmptyText.paint((Component)this, g);
            } else {
                super.paintChildren(g);
            }
        }
    }

    private class CommitSelectionListenerForDetails
    extends CommitSelectionListener<VcsCommitMetadata> {
        CommitSelectionListenerForDetails(VcsLogGraphTable graphTable) {
            super(graphTable, DetailsPanel.this.myLogData.getMiniDetailsGetter());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsCommitMetadata> detailsList) {
            List ids = ContainerUtil.map(detailsList, detail -> new CommitId((Hash)detail.getId(), detail.getRoot()));
            HashSet unResolvedHashes = ContainerUtil.newHashSet();
            List presentations = ContainerUtil.map(detailsList, detail -> CommitPresentationUtil.buildPresentation(DetailsPanel.this.myLogData.getProject(), detail, unResolvedHashes));
            DetailsPanel.this.setPresentations(ids, presentations);
            TIntHashSet newCommitIds = TroveUtil.map2IntSet(detailsList, c -> DetailsPanel.this.myLogData.getStorage().getCommitIndex((Hash)c.getId(), c.getRoot()));
            if (!TroveUtil.intersects(DetailsPanel.this.myCommitIds, newCommitIds)) {
                DetailsPanel.this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
            DetailsPanel.this.myCommitIds = newCommitIds;
            List currentSelection = DetailsPanel.this.mySelection;
            DetailsPanel.this.resolveHashes(ids, presentations, unResolvedHashes, (Condition<Object>)o -> currentSelection != DetailsPanel.this.mySelection);
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            DetailsPanel.this.cancelResolve();
            DetailsPanel.this.rebuildCommitPanels(selection);
            List currentSelection = DetailsPanel.this.mySelection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ArrayList result2 = ContainerUtil.newArrayList();
                for (Integer row2 : currentSelection) {
                    result2.add(this.myGraphTable.getModel().getRefsAtRow(row2));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (currentSelection == DetailsPanel.this.mySelection) {
                        for (int i = 0; i < currentSelection.size(); ++i) {
                            CommitPanel commitPanel = DetailsPanel.this.getCommitPanel(i);
                            commitPanel.setRefs((Collection)result2.get(i));
                        }
                    }
                });
            });
        }

        @Override
        protected void onEmptySelection() {
            DetailsPanel.this.cancelResolve();
            this.setEmpty("No commits selected");
        }

        @Override
        @NotNull
        protected List<Integer> getSelectionToLoad() {
            return DetailsPanel.this.mySelection;
        }

        @Override
        protected void startLoading() {
            DetailsPanel.this.myLoadingPanel.startLoading();
        }

        @Override
        protected void stopLoading() {
            DetailsPanel.this.myLoadingPanel.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            this.setEmpty("Error loading commits");
        }

        private void setEmpty(@NotNull String text) {
            DetailsPanel.this.myEmptyText.setText(text);
            DetailsPanel.this.myMainContentPanel.removeAll();
            DetailsPanel.this.mySelection = ContainerUtil.emptyList();
            DetailsPanel.this.myCommitIds = new TIntHashSet();
        }
    }
}

