/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider,
Disposable {
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final Splitter myPreviewDiffSplitter;
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MyCommitSelectionListenerForDiff mySelectionListenerForDiff;
    @NotNull
    private final VcsLogChangeProcessor myPreviewDiff;

    public MainFrame(@NotNull VcsLogData logData, @NotNull VcsLogUiImpl ui, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLog log2, @NotNull VisiblePack initialDataPack, @Nullable VcsLogFilterCollection filters) {
        this.myLogData = logData;
        this.myUi = ui;
        this.myLog = log2;
        this.myUiProperties = uiProperties;
        this.myFilterUi = new VcsLogClassicFilterUi(ui, logData, this.myUiProperties, initialDataPack, filters);
        this.myGraphTable = new MyVcsLogGraphTable(ui, logData, initialDataPack);
        this.myGraphTable.setCompactReferencesView(this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
        this.myGraphTable.setShowTagNames(this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        this.myDetailsPanel = new DetailsPanel(logData, ui.getColorManager(), this){

            @Override
            protected void navigate(@NotNull CommitId commit2) {
                MainFrame.this.myUi.jumpToCommit(commit2.getHash(), commit2.getRoot());
            }
        };
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function<? super CommitId, ? extends VcsShortCommitDetails>)((Function)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCommitData(index, Collections.singleton(index));
        }), this);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        this.myPreviewDiff = new VcsLogChangeProcessor(logData.getProject(), this.myChangesBrowser, this);
        this.myTextFilter = this.myFilterUi.createTextFilter();
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        this.myPreviewDiff.getToolbarWrapper().setVerticalSizeReferent(this.myToolbar);
        Runnable changesListener = () -> ApplicationManager.getApplication().invokeLater(() -> this.myPreviewDiff.updatePreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW)));
        this.myChangesBrowser.getViewer().addSelectionListener(changesListener);
        this.myChangesBrowser.setModelUpdateListener(changesListener);
        this.mySelectionListenerForDiff = new MyCommitSelectionListenerForDiff();
        this.myGraphTable.getSelectionModel().addListSelectionListener(this.mySelectionListenerForDiff);
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 2), this.myLogData, ui.getId(), this), "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.myChangesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.myPreviewDiffSplitter = new OnePixelSplitter(false, DIFF_SPLITTER_PROPORTION, 0.7f);
        this.myPreviewDiffSplitter.setHonorComponentsMinimumSize(false);
        this.myPreviewDiffSplitter.setFirstComponent((JComponent)this.myChangesBrowserSplitter);
        this.showDiffPreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPreviewDiffSplitter);
        Disposer.register((Disposable)ui, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(this.myUi));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        return this.myGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myFilterUi;
    }

    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("Vcs.Log.Toolbar.Internal"));
        if (BekUtil.isBekEnabled()) {
            Constraints constraint = new Constraints(Anchor.BEFORE, "Vcs.Log.PresentationSettings");
            if (BekUtil.isLinearBekEnabled()) {
                toolbarGroup.add((AnAction)new IntelliSortChooserPopupAction(), constraint);
            } else {
                toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"), constraint);
            }
        }
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.TextFilterSettings"));
        mainGroup.add((AnAction)new Separator());
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper((JComponent)this.myTextFilter);
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        ActionToolbar goToHashOrRefAction = this.createActionsToolbar(new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.GoToRef")}));
        goToHashOrRefAction.setReservePlaceAutoPopupIcon(false);
        goToHashOrRefAction.setLayoutPolicy(0);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]", "center"));
        panel2.add((Component)textFilter);
        panel2.add(toolbar.getComponent());
        panel2.add(goToHashOrRefAction.getComponent());
        return panel2;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar;
    }

    @NotNull
    public JComponent getMainComponent() {
        return this;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return this.myChangesBrowser.getDirectChanges().toArray(new Change[0]);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List details = this.myLog.getSelectedDetails();
            if (details.size() > 1000) {
                return null;
            }
            if (VcsLogUtil.getMaxSize(details) > VcsLogUtil.getShownChangesLimit()) {
                return null;
            }
            return ContainerUtil.map2Array((Collection)details, CommittedChangeListForRevision.class, VcsLogUtil::createCommittedChangeList);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUiProperties;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            return VfsUtilCore.toVirtualFileArray(roots);
        }
        if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
            Collection<VirtualFile> roots = this.getSelectedRoots();
            if (roots.size() != 1) {
                return null;
            }
            return this.myUi.getLogData().getLogProvider((VirtualFile)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(roots))).getDiffHandler();
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedRoots() {
        if (this.myUi.getLogData().getRoots().size() == 1) {
            return this.myUi.getLogData().getRoots();
        }
        int[] selectedRows = this.myGraphTable.getSelectedRows();
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            return VcsLogUtil.getVisibleRoots(this.myUi);
        }
        return ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.myGraphTable.getModel().getRoot((int)row2));
    }

    @NotNull
    public JComponent getToolbar() {
        return this.myToolbar;
    }

    @NotNull
    public SearchTextField getTextFilter() {
        return this.myTextFilter;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    public void showDiffPreview(boolean state) {
        this.myPreviewDiff.updatePreview(state);
        this.myPreviewDiffSplitter.setSecondComponent(state ? this.myPreviewDiff.getComponent() : null);
    }

    public void dispose() {
        this.myGraphTable.getSelectionModel().removeListSelectionListener(this.mySelectionListenerForDiff);
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private class MyVcsLogGraphTable
    extends VcsLogGraphTable {
        MyVcsLogGraphTable(@NotNull VcsLogUiImpl ui, @NotNull VcsLogData logData, VisiblePack initialDataPack) {
            super(ui, logData, initialDataPack, (Consumer<Runnable>)((Consumer)ui::requestMore));
        }

        @Override
        protected void updateEmptyText() {
            StatusText statusText = this.getEmptyText();
            VisiblePack visiblePack = this.getModel().getVisiblePack();
            if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                if (visiblePack.getFilters().isEmpty()) {
                    statusText.setText("No changes committed.").appendSecondaryText("Commit local changes", VcsLogUiUtil.getLinkAttributes(), ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                    if (!shortcutText.isEmpty()) {
                        statusText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                    }
                } else {
                    statusText.setText("No commits matching filters.").appendSecondaryText("Reset filters", VcsLogUiUtil.getLinkAttributes(), e -> MainFrame.this.myFilterUi.setFilter(null));
                }
            } else {
                statusText.setText("Changes log");
            }
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            return Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myPreviewDiff.getPreferredFocusedComponent(), MainFrame.this.myTextFilter.getTextEditor()});
        }
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListener<VcsFullCommitDetails> {
        protected MyCommitSelectionListenerForDiff() {
            super(MainFrame.this.myGraphTable, MainFrame.this.myLogData.getCommitDetailsGetter());
        }

        @Override
        protected void onEmptySelection() {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
            MainFrame.this.myChangesBrowser.setSelectedDetails(detailsList);
        }

        @Override
        protected void onSelection(@NotNull int[] selection) {
            MainFrame.this.myChangesBrowser.resetSelectedDetails();
        }

        @Override
        protected void startLoading() {
            MainFrame.this.myChangesLoadingPane.startLoading();
        }

        @Override
        protected void stopLoading() {
            MainFrame.this.myChangesLoadingPane.stopLoading();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            MainFrame.this.myChangesBrowser.setSelectedDetails(Collections.emptyList());
            MainFrame.this.myChangesBrowser.getViewer().setEmptyText("Error loading commits");
        }
    }
}

