/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;

    public ReferencesPanel() {
        this((LayoutManager)new WrappedFlowLayout(JBUI.scale((int)4), JBUI.scale((int)0)), -1);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        if (this.myReferences.equals(references)) {
            return;
        }
        this.myReferences = references;
        List visibleReferences = this.myRefsLimit > 0 ? ContainerUtil.getFirstItems(this.myReferences, (int)this.myRefsLimit) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy((Iterable)visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon = this.createIcon(type, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text = reference.getName() + ending;
                JBLabel label2 = this.createLabel(text, icon);
                if (firstLabel == null) {
                    firstLabel = label2;
                    this.add((Component)label2);
                } else {
                    this.addWrapped(label2, firstLabel);
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label3 = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label3, (JBLabel)ObjectUtils.assertNotNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        return this.createLabel("... " + restSize + " more", null);
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (refIndex == 0) {
            Color color = type.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? ContainerUtil.newArrayList((Object[])new Color[]{color, color}) : Collections.singletonList(color));
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label2, @NotNull JBLabel referent) {
        Wrapper wrapper2 = new Wrapper((JComponent)label2);
        wrapper2.setVerticalSizeReferent((JComponent)referent);
        this.add((Component)wrapper2);
    }

    @NotNull
    protected JBLabel createLabel(@NotNull String text, @Nullable Icon icon) {
        JBLabel label2 = new JBLabel(text, icon, 2);
        label2.setFont(this.getLabelsFont());
        label2.setIconTextGap(0);
        label2.setHorizontalAlignment(2);
        label2.setVerticalTextPosition(0);
        label2.setCopyable(true);
        return label2;
    }

    @NotNull
    protected Font getLabelsFont() {
        return FontUtil.getCommitMetadataFont();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }
}

