/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogChangeProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final VcsLogChangesBrowser myBrowser;

    VcsLogChangeProcessor(@NotNull Project project, @NotNull VcsLogChangesBrowser browser2, @NotNull Disposable disposable) {
        super(project, "VcsLogView");
        this.myBrowser = browser2;
        this.myContentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    @NotNull
    public Wrapper getToolbarWrapper() {
        return this.myToolbarWrapper;
    }

    @Override
    @NotNull
    protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        boolean hasSelection = this.myBrowser.getViewer().getSelectionModel().getSelectionCount() != 0;
        List<Change> changes2 = hasSelection ? this.myBrowser.getSelectedChanges() : this.myBrowser.getAllChanges();
        return ContainerUtil.map(changes2, x$0 -> new MyChangeWrapper((Change)x$0));
    }

    @Override
    @NotNull
    protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        return ContainerUtil.map(this.myBrowser.getAllChanges(), x$0 -> new MyChangeWrapper((Change)x$0));
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        TreePath path;
        ChangesTree tree = this.myBrowser.getViewer();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode objectNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)change.getUserObject());
        TreePath treePath = path = objectNode != null ? TreeUtil.getPathFromRoot((TreeNode)objectNode) : null;
        if (path != null) {
            TreeUtil.selectPath((JTree)((Object)tree), (TreePath)path, (boolean)false);
        }
    }

    public void updatePreview(boolean state) {
        if (state) {
            this.refresh(false);
        } else {
            this.clear();
        }
    }

    private class MyChangeWrapper
    extends ChangeViewDiffRequestProcessor.Wrapper {
        @NotNull
        private final Change myChange;

        MyChangeWrapper(Change change) {
            this.myChange = change;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.myChange;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return VcsLogChangeProcessor.this.myBrowser.getDiffRequestProducer(this.myChange, true);
        }
    }
}

