/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import gnu.trove.THashSet;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogChangesBrowser.class);
    @NotNull
    public static final DataKey<Boolean> HAS_AFFECTED_FILES = DataKey.create((String)"VcsLogChangesBrowser.HasAffectedFiles");
    @NotNull
    private final Project myProject;
    @NotNull
    private static final String EMPTY_SELECTION_TEXT = "Select commit to view details";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Function<? super CommitId, ? extends VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @NotNull
    private final Set<VirtualFile> myRoots = ContainerUtil.newHashSet();
    @NotNull
    private final List<Change> myChanges = ContainerUtil.newArrayList();
    @NotNull
    private final Map<CommitId, Set<Change>> myChangesToParents = ContainerUtil.newHashMap();
    @Nullable
    private Collection<FilePath> myAffectedPaths;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @Nullable
    private Runnable myModelUpdateListener;

    VcsLogChangesBrowser(@NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Function<? super CommitId, ? extends VcsShortCommitDetails> getter, @NotNull Disposable parent) {
        super(project, false, false);
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property) || MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES.equals(property)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myToolbarWrapper = new Wrapper(this.getToolbar().getComponent());
        this.init();
        this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected JComponent createToolbarComponent() {
        return this.myToolbarWrapper;
    }

    @Override
    @NotNull
    protected Border createViewerBorder() {
        return IdeBorderFactory.createBorder((int)2);
    }

    public void setToolbarHeightReferent(@NotNull JComponent referent) {
        this.myToolbarWrapper.setVerticalSizeReferent(referent);
    }

    public void setModelUpdateListener(@Nullable Runnable runnable2) {
        this.myModelUpdateListener = runnable2;
    }

    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        return ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Log.ChangesBrowser.Toolbar")});
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        return ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")});
    }

    public void resetSelectedDetails() {
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        this.myViewer.setEmptyText("");
        this.myViewer.rebuildTree();
        if (this.myModelUpdateListener != null) {
            this.myModelUpdateListener.run();
        }
    }

    public void setAffectedPaths(@Nullable Collection<FilePath> paths) {
        this.myAffectedPaths = paths;
        this.myViewer.rebuildTree();
    }

    public void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        this.setSelectedDetails(detailsList, false);
    }

    private void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> detailsList, boolean showBigCommits) {
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        if (detailsList.isEmpty()) {
            this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
        } else {
            int maxSize2 = VcsLogUtil.getMaxSize(detailsList);
            if (maxSize2 > VcsLogUtil.getShownChangesLimit() && !showBigCommits) {
                String commitText = detailsList.size() == 1 ? "This commit" : "One of the selected commits";
                String sizeText = VcsLogChangesBrowser.getSizeText(maxSize2);
                this.myViewer.getEmptyText().setText(commitText + " has " + sizeText + " changes").appendSecondaryText("Show anyway", VcsLogUiUtil.getLinkAttributes(), e -> this.setSelectedDetails(detailsList, true));
            } else {
                this.myRoots.addAll(ContainerUtil.map(detailsList, detail -> detail.getRoot()));
                if (detailsList.size() == 1) {
                    VcsFullCommitDetails detail2 = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(detailsList));
                    this.myChanges.addAll(detail2.getChanges());
                    if (detail2.getParents().size() > 1) {
                        for (int i = 0; i < detail2.getParents().size(); ++i) {
                            THashSet changesSet = ContainerUtil.newIdentityTroveSet((Collection)detail2.getChanges(i));
                            this.myChangesToParents.put(new CommitId((Hash)detail2.getParents().get(i), detail2.getRoot()), (Set<Change>)changesSet);
                        }
                    }
                    if (this.myChanges.isEmpty() && detail2.getParents().size() > 1) {
                        this.myViewer.getEmptyText().setText("No merged conflicts.").appendSecondaryText("Show changes to parents", VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
                    } else {
                        this.myViewer.setEmptyText("");
                    }
                } else {
                    this.myChanges.addAll(VcsLogUtil.collectChanges(detailsList, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)VcsFullCommitDetails::getChanges)));
                    this.myViewer.setEmptyText("");
                }
            }
        }
        this.myViewer.rebuildTree();
        if (this.myModelUpdateListener != null) {
            this.myModelUpdateListener.run();
        }
    }

    @NotNull
    private static String getSizeText(int maxSize2) {
        if (maxSize2 < 1000) {
            return String.valueOf(maxSize2);
        }
        DecimalFormat format = new DecimalFormat("#.#");
        format.setRoundingMode(RoundingMode.FLOOR);
        if (maxSize2 < 10000) {
            return format.format((double)maxSize2 / 1000.0) + "K";
        }
        if (maxSize2 < 1000000) {
            return maxSize2 / 1000 + "K";
        }
        if (maxSize2 < 10000000) {
            return format.format((double)maxSize2 / 1000000.0) + "M";
        }
        return maxSize2 / 1000000 + "M";
    }

    @Override
    @NotNull
    protected ChangesBrowserBase.ChangesBrowserTreeList createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        return new MyChangesTree(project, showCheckboxes, highlightProblems);
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        Collection<Change> changes2 = this.collectAffectedChanges(this.myChanges);
        HashMap changesToParents = ContainerUtil.newHashMap();
        for (Map.Entry<CommitId, Set<Change>> entry : this.myChangesToParents.entrySet()) {
            changesToParents.put(entry.getKey(), this.collectAffectedChanges((Collection<Change>)entry.getValue()));
        }
        MyTreeModelBuilder builder2 = new MyTreeModelBuilder();
        builder2.setChanges(changes2, null);
        if (this.isShowChangesFromParents() && !changesToParents.isEmpty()) {
            if (changes2.isEmpty()) {
                builder2.addEmptyTextNode("No merged conflicts");
            }
            for (CommitId commitId : changesToParents.keySet()) {
                Collection changesFromParent = (Collection)changesToParents.get(commitId);
                if (changesFromParent.isEmpty()) continue;
                builder2.addChangesFromParentNode(changesFromParent, commitId);
            }
        }
        return builder2.build();
    }

    @NotNull
    private Collection<Change> collectAffectedChanges(@NotNull Collection<Change> changes2) {
        if (!this.isShowOnlyAffected() || this.myAffectedPaths == null) {
            return changes2;
        }
        return ContainerUtil.filter(changes2, change -> ContainerUtil.or(this.myAffectedPaths, filePath -> {
            if (filePath.isDirectory()) {
                return FileHistoryUtil.affectsDirectory(change, filePath);
            }
            return FileHistoryUtil.affectsFile(change, filePath, false) || FileHistoryUtil.affectsFile(change, filePath, true);
        }));
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    private boolean isShowOnlyAffected() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) != false;
    }

    @NotNull
    public List<Change> getDirectChanges() {
        return this.myChanges;
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @NotNull
    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.getVcs();
            if (vcs == null) {
                return null;
            }
            return vcs.getKeyInstanceMethod();
        }
        if (HAS_AFFECTED_FILES.is(dataId)) {
            return this.myAffectedPaths != null;
        }
        return super.getData(dataId);
    }

    @Nullable
    private AbstractVcs getVcs() {
        List allVcs = ContainerUtil.mapNotNull(this.myRoots, root -> ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root));
        if (allVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)allVcs));
        }
        Set selectedVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
        if (selectedVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)selectedVcs));
        }
        return null;
    }

    @Override
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        return this.getDiffRequestProducer(userObject, false);
    }

    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject, boolean forDiffPreview) {
        if (!(userObject instanceof Change)) {
            return null;
        }
        Change change = (Change)userObject;
        HashMap context = ContainerUtil.newHashMap();
        if (!(change instanceof MergedChange)) {
            this.putRootTagIntoChangeContext(change, context);
        }
        return VcsLogChangesBrowser.createDiffRequestProducer(this.myProject, change, context, forDiffPreview);
    }

    @Nullable
    public static ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull Project project, @NotNull Change change, @NotNull Map<Key, Object> context, boolean forDiffPreview) {
        MergedChange mergedChange;
        if (change instanceof MergedChange && (mergedChange = (MergedChange)change).getSourceChanges().size() == 2) {
            if (forDiffPreview) {
                VcsLogChangesBrowser.putFilePathsIntoMergedChangeContext(mergedChange, context);
            }
            return new MergedChangeDiffRequestProvider.MyProducer(project, mergedChange, context);
        }
        if (forDiffPreview) {
            VcsLogChangesBrowser.putFilePathsIntoChangeContext(change, context);
        }
        return ChangeDiffRequestProducer.create(project, change, context);
    }

    private void putRootTagIntoChangeContext(@NotNull Change change, @NotNull Map<Key, Object> context) {
        CommitId parentId = null;
        for (CommitId commitId : this.myChangesToParents.keySet()) {
            if (!this.myChangesToParents.get(commitId).contains(change)) continue;
            parentId = commitId;
            break;
        }
        if (parentId != null) {
            RootTag tag = new RootTag(parentId.getHash(), this.getText(parentId));
            context.put(ChangeDiffRequestProducer.TAG_KEY, tag);
        }
    }

    private static void putFilePathsIntoMergedChangeContext(@NotNull MergedChange change, @NotNull Map<Key, Object> context) {
        ContentRevision centerRevision = change.getAfterRevision();
        ContentRevision leftRevision = change.getSourceChanges().get(0).getBeforeRevision();
        ContentRevision rightRevision = change.getSourceChanges().get(1).getBeforeRevision();
        FilePath centerFile = centerRevision == null ? null : centerRevision.getFile();
        FilePath leftFile = leftRevision == null ? null : leftRevision.getFile();
        FilePath rightFile = rightRevision == null ? null : rightRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_CENTER_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(centerRevision, centerFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(rightRevision, rightFile, centerFile));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(leftRevision, leftFile, centerFile == null ? rightFile : centerFile));
    }

    private static void putFilePathsIntoChangeContext(@NotNull Change change, @NotNull Map<Key, Object> context) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        FilePath aFile = afterRevision == null ? null : afterRevision.getFile();
        FilePath bFile = beforeRevision == null ? null : beforeRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(afterRevision, aFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(beforeRevision, bFile, aFile));
    }

    @NotNull
    private static String getRevisionTitle(@Nullable ContentRevision revision, @Nullable FilePath file2, @Nullable FilePath baseFile) {
        return VcsLogChangesBrowser.getShortHash(revision) + (file2 == null || FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)baseFile, (Object)file2) ? "" : " (" + VcsLogChangesBrowser.getRelativeFileName(baseFile, file2) + ")");
    }

    @NotNull
    private static String getShortHash(@Nullable ContentRevision revision) {
        if (revision == null) {
            return "";
        }
        VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
        if (revisionNumber instanceof ShortVcsRevisionNumber) {
            return ((ShortVcsRevisionNumber)revisionNumber).toShortString();
        }
        return revisionNumber.asString();
    }

    @NotNull
    private static String getRelativeFileName(@Nullable FilePath baseFile, @NotNull FilePath file2) {
        if (baseFile == null || !baseFile.getName().equals(file2.getName())) {
            return file2.getName();
        }
        FilePath aParentPath = baseFile.getParentPath();
        if (aParentPath == null) {
            return file2.getName();
        }
        return VcsFileUtil.relativePath(aParentPath.getIOFile(), file2.getIOFile());
    }

    @NotNull
    private String getText(@NotNull CommitId commitId) {
        String text = "Changes to " + commitId.getHash().toShortString();
        VcsShortCommitDetails detail = (VcsShortCommitDetails)this.myDataGetter.fun((Object)commitId);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text = text + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        return text;
    }

    protected class MyChangesTree
    extends ChangesBrowserBase.ChangesBrowserTreeList {
        MyChangesTree(Project project, boolean showCheckboxes, boolean highlightProblems) {
            super(VcsLogChangesBrowser.this, project, showCheckboxes, highlightProblems);
        }

        @Override
        protected void resetTreeState() {
            long start2 = System.currentTimeMillis();
            if (VcsLogChangesBrowser.this.isShowChangesFromParents()) {
                TreeUtil.expand((JTree)((Object)this), path -> {
                    if (path.getLastPathComponent() instanceof ChangesBrowserParentNode) {
                        return TreeVisitor.Action.SKIP_CHILDREN;
                    }
                    return TreeVisitor.Action.CONTINUE;
                }, path -> {});
            } else {
                TreeUtil.expandAll((JTree)((Object)this));
            }
            LOG.debug("Resetting changes tree state took " + StopWatch.formatTime(System.currentTimeMillis() - start2));
        }
    }

    private static class RootTag {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final String myText;

        RootTag(@NotNull Hash commit2, @NotNull String text) {
            this.myCommit = commit2;
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootTag tag = (RootTag)o;
            return Objects.equals(this.myCommit, tag.myCommit);
        }

        public int hashCode() {
            return Objects.hash(this.myCommit);
        }
    }

    private class ChangesBrowserParentNode
    extends ChangesBrowserNode<String> {
        protected ChangesBrowserParentNode(CommitId commitId) {
            super(VcsLogChangesBrowser.this.getText(commitId));
        }
    }

    private static class ChangesBrowserEmptyTextNode
    extends ChangesBrowserNode<String> {
        protected ChangesBrowserEmptyTextNode(@NotNull String text) {
            super(text);
        }
    }

    private class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder() {
            super(VcsLogChangesBrowser.this.myProject, VcsLogChangesBrowser.this.getGrouping());
        }

        public void addEmptyTextNode(@NotNull String text) {
            ChangesBrowserEmptyTextNode textNode = new ChangesBrowserEmptyTextNode(text);
            textNode.markAsHelperNode();
            this.myModel.insertNodeInto(textNode, this.myRoot, this.myRoot.getChildCount());
        }

        public void addChangesFromParentNode(@NotNull Collection<? extends Change> changes2, @NotNull CommitId commitId) {
            ChangesBrowserParentNode parentNode = new ChangesBrowserParentNode(commitId);
            parentNode.markAsHelperNode();
            this.myModel.insertNodeInto(parentNode, this.myRoot, this.myRoot.getChildCount());
            for (Change change : changes2) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }
    }
}

