/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = JBColor.namedColor((String)"VersionControl.Log.Commit.currentBranchBackground", (Color)new JBColor(new Color(228, 250, 255), new Color(63, 71, 73)));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    @NotNull
    private final Map<VirtualFile, Boolean> myIsHighlighted = ContainerUtil.newHashMap();

    public CurrentBranchHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (isSelected || !this.myLogUi.isHighlighterEnabled("CURRENT_BRANCH")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        if (!this.myIsHighlighted.getOrDefault(details.getRoot(), false).booleanValue()) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        Condition<Integer> condition = this.myLogData.getContainingBranchesGetter().getContainedInCurrentBranchCondition(details.getRoot());
        if (condition.value((Object)commitId)) {
            return VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch(dataPack.getFilters(), dataPack.getRefs());
        this.myIsHighlighted.clear();
        boolean isHeadFilter = "HEAD".equals(singleFilteredBranch);
        for (VirtualFile root : dataPack.getLogProviders().keySet()) {
            String currentBranch = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getCurrentBranch(root);
            this.myIsHighlighted.put(root, !isHeadFilter && currentBranch != null && !currentBranch.equals(singleFilteredBranch));
        }
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new CurrentBranchHighlighter(logData, logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "Current Branch";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

