/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class MergeCommitsHighlighter
implements VcsLogHighlighter {
    public static final JBColor MERGE_COMMIT_FOREGROUND = JBColor.namedColor((String)"VersionControl.Log.Commit.unmatchedForeground", (Color)new JBColor((Color)Gray._128, (Color)Gray._96));
    @NotNull
    private final VcsLogUi myLogUi;

    public MergeCommitsHighlighter(@NotNull VcsLogUi logUi) {
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        if (isSelected || !this.myLogUi.isHighlighterEnabled("MERGE_COMMITS")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        if (details.getParents().size() >= 2) {
            return VcsCommitStyleFactory.foreground((Color)MERGE_COMMIT_FOREGROUND);
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MERGE_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new MergeCommitsHighlighter(logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "Merge Commits";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

