/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.filters.VcsLogUserFilterImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myLogUi;
    private boolean myShouldHighlightUser = false;

    public MyCommitsHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
        this.myLogData = logData;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails details, boolean isSelected) {
        VcsUser currentUser;
        if (!this.myLogUi.isHighlighterEnabled("MY_COMMITS")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        if (this.myShouldHighlightUser && (currentUser = this.myLogData.getCurrentUser().get(details.getRoot())) != null && VcsUserUtil.isSamePerson(currentUser, details.getAuthor())) {
            return VcsCommitStyleFactory.bold();
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        this.myShouldHighlightUser = !this.isSingleUser() && !MyCommitsHighlighter.isFilteredByCurrentUser(dataPack.getFilters());
    }

    private boolean isSingleUser() {
        NotNullFunction nameToString = user -> VcsUserUtil.getNameInStandardForm(VcsUserUtil.getShortPresentation(user));
        HashSet allUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myLogData.getAllUsers(), (Function)nameToString));
        HashSet currentUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myLogData.getCurrentUser().values(), (Function)nameToString));
        return allUserNames.size() == currentUserNames.size() && currentUserNames.containsAll(allUserNames);
    }

    private static boolean isFilteredByCurrentUser(@NotNull VcsLogFilterCollection filters) {
        VcsLogUserFilter userFilter = (VcsLogUserFilter)filters.get(VcsLogFilterCollection.USER_FILTER);
        if (userFilter == null) {
            return false;
        }
        Collection<String> filterByName = ((VcsLogUserFilterImpl)userFilter).getUserNamesForPresentation();
        return Collections.singleton("me").containsAll(filterByName);
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            return new MyCommitsHighlighter(logData, logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "My Commits";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

