/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue RIGHT_PADDING = JBVG.value(4.0f);
    public static final JBValue LEFT_PADDING = JBVG.value(4.0f);
    public static final JBValue COMPACT_MIDDLE_PADDING = JBVG.value(2.0f);
    public static final JBValue MIDDLE_PADDING = JBVG.value(12.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor TEXT_COLOR = CurrentBranchComponent.TEXT_COLOR;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final LabelIconCache myIconCache;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels = ContainerUtil.newArrayList();
    private int myHeight = JBUI.scale((int)22);
    private int myWidth = 0;
    @NotNull
    private Color myBackground = UIUtil.getTableBackground();
    @Nullable
    private Color myGreyBackground = null;
    @NotNull
    private Color myForeground = UIUtil.getTableForeground();
    private boolean myCompact;
    private boolean myShowTagNames;

    public LabelPainter(@NotNull VcsLogData data, @NotNull JComponent component, @NotNull LabelIconCache iconCache, boolean compact, boolean showTagNames) {
        this.myLogData = data;
        this.myComponent = component;
        this.myIconCache = iconCache;
        this.myCompact = compact;
        this.myShowTagNames = showTagNames;
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<? extends VcsRef> references) {
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }

    public void customizePainter(@NotNull Collection<? extends VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
        VcsLogRefManager manager = LabelPainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references, this.myCompact, this.myShowTagNames);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = this.calculatePresentation(refGroups, metrics, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth, boolean compact) {
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        if (compact) {
            return this.calculateCompactPresentation(refGroups, fontMetrics, background, availableWidth);
        }
        return this.calculateLongPresentation(refGroups, fontMetrics, background, availableWidth);
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        for (RefGroup refGroup : refGroups) {
            List colors = refGroup.getColors();
            LabelIcon labelIcon = this.getIcon(fontMetrics.getHeight(), background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (refGroup != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING.get() : 0);
            String text = LabelPainter.shortenRefName(refGroup.getName(), fontMetrics, availableWidth - newWidth);
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth += fontMetrics.stringWidth(text);
        }
        return Pair.create((Object)labels, (Object)width);
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            return Pair.create((Object)labels, (Object)width);
        }
        int height = fontMetrics.getHeight();
        for (int i = 0; i < refGroups.size(); ++i) {
            String text;
            RefGroup group = refGroups.get(i);
            int doNotFitWidth = 0;
            if (i < refGroups.size() - 1) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (i != refGroups.size() - 1 ? MIDDLE_PADDING.get() : 0);
            if (availableWidth - (newWidth += fontMetrics.stringWidth(text = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth))) - doNotFitWidth < 0) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name = labels.isEmpty() ? text : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth;
        }
        return Pair.create((Object)labels, (Object)width);
    }

    @NotNull
    private LabelIcon getIcon(int height, @NotNull Color background, @NotNull List<? extends Color> colors) {
        return this.myIconCache.getIcon(this.myComponent, height, background, colors);
    }

    @NotNull
    private static List<Color> getColors(@NotNull Collection<? extends RefGroup> groups) {
        LinkedHashMap usedColors = ContainerUtil.newLinkedHashMap();
        for (RefGroup refGroup : groups) {
            List colors = refGroup.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add(entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add(entry.getKey());
        }
        return result2;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (!group.isExpanded()) {
            return LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
        }
        StringBuilder text = new StringBuilder();
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i = 0; i < group.getRefs().size(); ++i) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text.append(remainder);
                break;
            }
            text.append(firstRef ? "" : separator).append(refName);
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        return text.toString();
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<? extends RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        for (RefGroup refGroup : refGroups) {
            boolean paintGreyBackground;
            if (refGroup.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)refGroup.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !refGroup.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                return refName;
            }
            if (availableWidth > 0) {
                for (int i = refName.length(); i > 22; --i) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    return result2;
                }
            }
            return StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
        }
        return refName;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(LabelPainter.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x, y, this.myWidth, height);
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get());
        }
        x += LEFT_PADDING.get();
        for (Pair<String, LabelIcon> label2 : this.myLabels) {
            LabelIcon icon = (LabelIcon)label2.second;
            String text = (String)label2.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - MIDDLE_PADDING.get() / 3, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), icon.getIconWidth() + fontMetrics.stringWidth(text) + 2 * MIDDLE_PADDING.get() / 3, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get(), LABEL_ARC.get(), LABEL_ARC.get()));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text, x += icon.getIconWidth(), y + baseLine);
            x += fontMetrics.stringWidth(text) + (this.myCompact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get());
        }
        config2.restore();
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return Registry.is((String)"vcs.log.labels.left.aligned");
    }

    public static Font getReferenceFont() {
        Font font = GraphCommitCellRenderer.getLabelFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setShowTagNames(boolean showTagNames) {
        this.myShowTagNames = showTagNames;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }
}

