/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitSelectionListener<T extends VcsCommitMetadata>
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance(CommitSelectionListener.class);
    @NotNull
    protected final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DataGetter<? extends T> myCommitDetailsGetter;
    @Nullable
    private ListSelectionEvent myLastEvent;
    @Nullable
    private ProgressIndicator myLastRequest;

    protected CommitSelectionListener(@NotNull VcsLogGraphTable table, @NotNull DataGetter<? extends T> dataGetter) {
        this.myGraphTable = table;
        this.myCommitDetailsGetter = dataGetter;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        this.myLastEvent = event;
        if (this.myLastRequest != null) {
            this.myLastRequest.cancel();
        }
        this.myLastRequest = null;
        ApplicationManager.getApplication().invokeLater(this::processEvent, o -> this.myLastEvent != event);
    }

    public void processEvent() {
        int rows = this.myGraphTable.getSelectedRowCount();
        if (rows < 1) {
            this.stopLoading();
            this.onEmptySelection();
        } else {
            this.onSelection(this.myGraphTable.getSelectedRows());
            this.startLoading();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.myLastRequest = indicator;
            List<Integer> selectionToLoad = this.getSelectionToLoad();
            this.myCommitDetailsGetter.loadCommitsData(this.myGraphTable.getModel().convertToCommitIds(selectionToLoad), detailsList -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    LOG.assertTrue(selectionToLoad.size() == detailsList.size(), (Object)("Loaded incorrect number of details " + detailsList + " for selection " + selectionToLoad));
                    this.myLastRequest = null;
                    this.onDetailsLoaded((List<? extends T>)detailsList);
                    this.stopLoading();
                }
            }, (Consumer<Throwable>)((Consumer)t -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    this.myLastRequest = null;
                    this.onError((Throwable)t);
                    this.stopLoading();
                }
            }), (ProgressIndicator)indicator);
        }
    }

    @NotNull
    protected List<Integer> getSelectionToLoad() {
        return Ints.asList((int[])this.myGraphTable.getSelectedRows());
    }

    protected abstract void startLoading();

    protected abstract void stopLoading();

    protected abstract void onError(@NotNull Throwable var1);

    protected abstract void onDetailsLoaded(@NotNull List<? extends T> var1);

    protected abstract void onSelection(@NotNull int[] var1);

    protected abstract void onEmptySelection();
}

