/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableController {
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final GraphCellPainter myGraphCellPainter;
    @NotNull
    private final GraphCommitCellRenderer myCommitRenderer;

    public GraphTableController(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull VcsLogUiProperties properties, @NotNull VcsLogGraphTable table, @NotNull GraphCellPainter graphCellPainter, @NotNull GraphCommitCellRenderer commitRenderer) {
        this.myTable = table;
        this.myLogData = logData;
        this.myProperties = properties;
        this.myColorManager = colorManager;
        this.myGraphCellPainter = graphCellPainter;
        this.myCommitRenderer = commitRenderer;
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        table.addMouseMotionListener(mouseAdapter);
        table.addMouseListener(mouseAdapter);
    }

    @Nullable
    PrintElement findPrintElement(@NotNull MouseEvent e) {
        int row2 = this.myTable.rowAtPoint(e.getPoint());
        if (row2 >= 0 && row2 < this.myTable.getRowCount()) {
            return this.findPrintElement(row2, e);
        }
        return null;
    }

    @Nullable
    private PrintElement findPrintElement(int row2, @NotNull MouseEvent e) {
        Point point = this.calcPoint4Graph(e.getPoint());
        Collection printElements = this.myTable.getVisibleGraph().getRowInfo(row2).getPrintElements();
        return this.myGraphCellPainter.getElementUnderCursor(printElements, point.x, point.y);
    }

    private void performGraphAction(@Nullable PrintElement printElement, @NotNull MouseEvent e, @NotNull GraphAction.Type actionType) {
        boolean isClickOnGraphElement;
        boolean bl = isClickOnGraphElement = actionType == GraphAction.Type.MOUSE_CLICK && printElement != null;
        if (isClickOnGraphElement) {
            GraphTableController.triggerElementClick(printElement);
        }
        Selection previousSelection = this.myTable.getSelection();
        GraphAnswer answer = this.myTable.getVisibleGraph().getActionController().performAction((GraphAction)new GraphAction.GraphActionImpl(printElement, actionType));
        this.handleGraphAnswer((GraphAnswer<Integer>)answer, isClickOnGraphElement, previousSelection, e);
    }

    public void handleGraphAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable Selection previousSelection, @Nullable MouseEvent e) {
        if (dataCouldChange) {
            this.myTable.getModel().fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.myTable.getVisibleGraph(), answer == null || answer.getCommitToJump() != null && answer.doJump(), false);
            }
        }
        this.myTable.repaint();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.myTable.setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null) {
            Integer row2 = this.myTable.getModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump());
            if (row2 != null && row2 >= 0 && answer.doJump()) {
                this.myTable.jumpToRow(row2);
                return;
            }
            if (e != null) {
                this.showToolTip(this.getArrowTooltipText((Integer)answer.getCommitToJump(), row2), e);
            }
        }
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        TableColumn column;
        int width = 0;
        for (int i = 0; i < this.myTable.getColumnModel().getColumnCount() && (column = this.myTable.getColumnModel().getColumn(i)).getModelIndex() != 1; ++i) {
            width += column.getWidth();
        }
        return new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.myTable.getRowHeight()));
    }

    @NotNull
    private String getArrowTooltipText(int commit2, @Nullable Integer row2) {
        Object details = row2 != null && row2 >= 0 ? this.myTable.getModel().getCommitMetadata(row2) : this.myLogData.getMiniDetailsGetter().getCommitData(commit2, Collections.singleton(commit2));
        String balloonText = "";
        if (details instanceof LoadingDetails) {
            CommitId commitId = this.myLogData.getCommitId(commit2);
            if (commitId != null) {
                balloonText = "Jump to commit " + commitId.getHash().toShortString();
                if (this.myColorManager.isMultipleRoots()) {
                    balloonText = balloonText + " in " + commitId.getRoot().getName();
                }
            }
        } else {
            balloonText = "Jump to " + CommitPresentationUtil.getShortSummary(details);
        }
        return balloonText;
    }

    private void showToolTip(@NotNull String text, @NotNull MouseEvent e) {
        VcsLogUiUtil.showTooltip((JComponent)((Object)this.myTable), new Point(e.getX() + 5, e.getY()), Balloon.Position.atRight, text);
    }

    private void showOrHideCommitTooltip(int row2, int column, @NotNull MouseEvent e) {
        if (!this.showTooltip(row2, column, e.getPoint(), false) && IdeTooltipManager.getInstance().hasCurrent()) {
            IdeTooltipManager.getInstance().hideCurrent(e);
        }
    }

    private boolean showTooltip(int row2, int column, @NotNull Point point, boolean now) {
        JComponent tipComponent = this.myCommitRenderer.getTooltip(this.myTable.getValueAt(row2, this.myTable.convertColumnIndexToView(column)), this.calcPoint4Graph(point), row2);
        if (tipComponent != null) {
            this.myTable.getExpandableItemsHandler().setEnabled(false);
            IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper(tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.below);
            IdeTooltipManager.getInstance().show(tooltip, now);
            return true;
        }
        return false;
    }

    public void showTooltip(int row2) {
        Point point = new Point(this.getColumnLeftXCoordinate(this.myTable.convertColumnIndexToView(1)) + this.myCommitRenderer.getTooltipXCoordinate(row2), row2 * this.myTable.getRowHeight() + this.myTable.getRowHeight() / 2);
        this.showTooltip(row2, 1, point, true);
    }

    private void performRootColumnAction() {
        if (this.myColorManager.isMultipleRoots() && this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES)) {
            VcsLogUsageTriggerCollector.triggerUsage("RootColumnClick");
            this.myProperties.set(CommonUiProperties.SHOW_ROOT_NAMES, this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) == false);
        }
    }

    private static void triggerElementClick(@NotNull PrintElement printElement) {
        if (printElement instanceof NodePrintElement) {
            VcsLogUsageTriggerCollector.triggerUsage("GraphNodeClick");
        } else if (printElement instanceof EdgePrintElement && ((EdgePrintElement)printElement).hasArrow()) {
            VcsLogUsageTriggerCollector.triggerUsage("GraphArrowClick");
        }
    }

    protected int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x = 0;
        for (int i = 0; i < viewColumnIndex; ++i) {
            x += this.myTable.getColumnModel().getColumn(i).getWidth();
        }
        return x;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new MyLinkMouseListener();
        @Nullable
        private Cursor myLastCursor = null;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row2;
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = GraphTableController.this.myTable.columnAtPoint(e.getPoint());
            int column = GraphTableController.this.myTable.convertColumnIndexToModel(c);
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = GraphTableController.this.myTable.convertColumnIndexToView(1);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && (column == 2 || column == 3)) {
                    GraphTableController.this.myTable.resetColumnWidth(column);
                } else {
                    int c2 = GraphTableController.this.myTable.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUI.scale((int)3), e.getPoint().y));
                    int column2 = GraphTableController.this.myTable.convertColumnIndexToModel(c2);
                    if ((useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && (column2 == 2 || column2 == 3)) {
                        GraphTableController.this.myTable.resetColumnWidth(column2);
                    }
                }
            }
            if ((row2 = GraphTableController.this.myTable.rowAtPoint(e.getPoint())) >= 0 && row2 < GraphTableController.this.myTable.getRowCount() && e.getClickCount() == 1) {
                PrintElement printElement;
                if (column == 0) {
                    GraphTableController.this.performRootColumnAction();
                } else if (column == 1 && (printElement = GraphTableController.this.findPrintElement(row2, e)) != null) {
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_CLICK);
                }
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) - e.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) + GraphTableController.this.myTable.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (GraphTableController.this.myTable.isResizingColumns()) {
                return;
            }
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e) != null) {
                this.swapCursor(12);
                return;
            }
            int row2 = GraphTableController.this.myTable.rowAtPoint(e.getPoint());
            if (row2 >= 0 && row2 < GraphTableController.this.myTable.getRowCount()) {
                int column = GraphTableController.this.myTable.convertColumnIndexToModel(GraphTableController.this.myTable.columnAtPoint(e.getPoint()));
                if (column == 0) {
                    this.swapCursor(12);
                    return;
                }
                if (column == 1) {
                    PrintElement printElement = GraphTableController.this.findPrintElement(row2, e);
                    if (printElement == null) {
                        this.restoreCursor(12);
                    }
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_OVER);
                    if (printElement == null) {
                        GraphTableController.this.showOrHideCommitTooltip(row2, column, e);
                    }
                    return;
                }
            }
            this.restoreCursor(12);
        }

        private void swapCursor(int newCursorType) {
            if (GraphTableController.this.myTable.getCursor().getType() != newCursorType && this.myLastCursor == null) {
                Cursor newCursor = Cursor.getPredefinedCursor(newCursorType);
                this.myLastCursor = GraphTableController.this.myTable.getCursor();
                GraphTableController.this.myTable.setCursor(newCursor);
            }
        }

        private void restoreCursor(int newCursorType) {
            if (this.myLastCursor != null && GraphTableController.this.myTable.getCursor().getType() == newCursorType) {
                GraphTableController.this.myTable.setCursor(this.myLastCursor);
                this.myLastCursor = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
        }

        private class MyLinkMouseListener
        extends SimpleColoredComponentLinkMouseListener {
            private MyLinkMouseListener() {
            }

            @Override
            @Nullable
            public Object getTagAt(@NotNull MouseEvent e) {
                return ObjectUtils.tryCast((Object)super.getTagAt(e), SimpleColoredComponent.BrowserLauncherTag.class);
            }
        }
    }
}

