/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    public static final int COMMIT_NOT_FOUND = -1;
    public static final int COMMIT_DOES_NOT_MATCH = -2;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Consumer<? super Runnable> myRequestMore;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogData logData, @NotNull Consumer<? super Runnable> requestMore) {
        this.myLogData = logData;
        this.myDataPack = dataPack;
        this.myRequestMore = requestMore;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        return this.myDataPack.getRoot(rowIndex);
    }

    @NotNull
    public Integer getIdAtRow(int row2) {
        return (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row2).getCommit();
    }

    @Nullable
    public CommitId getCommitIdAtRow(int row2) {
        return this.myLogData.getCommitId(this.getIdAtRow(row2));
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (!this.myLogData.getStorage().containsCommit(new CommitId(hash, root))) {
            return -1;
        }
        return this.getRowOfCommitWithoutCheck(hash, root);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        Ref commitExists = new Ref((Object)false);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<? super CommitId>)((Condition)commitId1 -> {
            if (hashByString.value((CommitId)commitId1)) {
                commitExists.set((Object)true);
                return this.getRowOfCommitWithoutCheck(commitId1.getHash(), commitId1.getRoot()) >= 0;
            }
            return false;
        }));
        return commitId != null ? this.getRowOfCommitWithoutCheck(commitId.getHash(), commitId.getRoot()) : ((Boolean)commitExists.get() != false ? -2 : -1);
    }

    private int getRowOfCommitWithoutCheck(@NotNull Hash hash, @NotNull VirtualFile root) {
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        Integer rowIndex = this.myDataPack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
        return rowIndex == null ? -2 : rowIndex;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        this.myMoreRequested = true;
        this.myRequestMore.consume((Object)onLoaded);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsCommitMetadata data = this.getCommitMetadata(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.getRoot(rowIndex);
            }
            case 1: {
                return new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
            }
            case 2: {
                return CommitPresentationUtil.getAuthorPresentation((VcsShortCommitDetails)data);
            }
            case 3: {
                if (data.getAuthorTime() < 0L) {
                    return "";
                }
                return DateFormatUtil.formatDateTime((long)data.getAuthorTime());
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + (this.getColumnCount() - 1));
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + (this.getColumnCount() - 1));
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        return this.myDataPack;
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row2) {
        return this.getDetails(row2, this.myLogData.getCommitDetailsGetter());
    }

    @NotNull
    public VcsCommitMetadata getCommitMetadata(int row2) {
        return this.getDetails(row2, this.myLogData.getMiniDetailsGetter());
    }

    @NotNull
    private <T extends VcsShortCommitDetails> T getDetails(int row2, @NotNull DataGetter<T> dataGetter) {
        Iterable<Integer> iterable = this.createRowsIterable(row2, 20, 40, this.getRowCount());
        return dataGetter.getCommitData(this.getIdAtRow(row2), iterable);
    }

    @NotNull
    public Collection<VcsRef> getRefsAtRow(int row2) {
        return ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row2));
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row2) {
        return ContainerUtil.filter(this.getRefsAtRow(row2), ref -> ref.getType().isBranch());
    }

    @NotNull
    private Iterable<Integer> createRowsIterable(final int row2, final int above, final int below, final int maxRows) {
        return () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row2 - above);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row2 + below && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        return ContainerUtil.map(rows, (Function)((NotNullFunction)this::getIdAtRow));
    }
}

