/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogSpeedSearch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexSpeedSearch
extends VcsLogSpeedSearch {
    @NotNull
    private final VcsLogIndex myIndex;
    @NotNull
    private final VcsUserRegistry myUserRegistry;
    @Nullable
    private Set<Integer> myMatchedByUserCommits;
    @Nullable
    private Collection<VcsUser> myMatchedUsers;

    public IndexSpeedSearch(@NotNull Project project, @NotNull VcsLogIndex index, @NotNull VcsLogGraphTable component) {
        super(component);
        this.myIndex = index;
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
        this.addChangeListener(evt -> {
            if (evt.getPropertyName().equals("enteredPrefix")) {
                String newValue = (String)evt.getNewValue();
                IndexDataGetter dataGetter = this.myIndex.getDataGetter();
                if (newValue != null && dataGetter != null) {
                    String oldValue = (String)evt.getOldValue();
                    Collection<Object> usersToExamine = this.myUserRegistry.getUsers();
                    if (oldValue != null && this.myMatchedUsers != null && newValue.contains(oldValue)) {
                        if (this.myMatchedUsers.isEmpty()) {
                            return;
                        }
                        usersToExamine = this.myMatchedUsers;
                    }
                    this.myMatchedUsers = ContainerUtil.filter((Collection)usersToExamine, user -> this.compare(VcsUserUtil.getShortPresentation(user), newValue));
                    this.myMatchedByUserCommits = dataGetter.filter(Collections.singletonList(new SimpleVcsLogUserFilter(this.myMatchedUsers)));
                } else {
                    this.myMatchedByUserCommits = null;
                    this.myMatchedUsers = null;
                }
            }
        });
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        if (super.isSpeedSearchEnabled()) {
            VisiblePack visiblePack = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getVisiblePack();
            Set<VirtualFile> roots = visiblePack.getLogProviders().keySet();
            Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(roots, visiblePack.getFilters());
            for (VirtualFile root : visibleRoots) {
                if (this.myIndex.isIndexed(root)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected String getElementText(@NotNull Object row2) {
        throw new UnsupportedOperationException("Getting row text in a Log is unsupported since we match commit subject and author separately.");
    }

    @Nullable
    private String getCommitSubject(@NotNull Integer row2) {
        Integer id;
        String message;
        IndexDataGetter dataGetter = this.myIndex.getDataGetter();
        if (dataGetter != null && (message = dataGetter.getFullMessage(id = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow(row2))) != null) {
            return IndexedDetails.getSubject(message);
        }
        return super.getElementText(row2);
    }

    @Override
    protected boolean isMatchingElement(Object row2, String pattern) {
        String str = this.getCommitSubject((Integer)row2);
        return str != null && this.compare(str, pattern) || this.myMatchedByUserCommits != null && !this.myMatchedByUserCommits.isEmpty() && this.myMatchedByUserCommits.contains(((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow((Integer)row2));
    }

    private static class SimpleVcsLogUserFilter
    implements VcsLogUserFilter {
        @NotNull
        private final Collection<VcsUser> myMatchedUsers;

        SimpleVcsLogUserFilter(@NotNull Collection<VcsUser> matchedUsers) {
            this.myMatchedUsers = matchedUsers;
        }

        @NotNull
        public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
            return this.myMatchedUsers;
        }

        public boolean matches(@NotNull VcsCommitMetadata details) {
            return this.myMatchedUsers.contains(details.getAuthor());
        }

        @NotNull
        public String getPresentation() {
            return StringUtil.join(this.myMatchedUsers, user -> VcsUserUtil.toExactString(user), (String)", ");
        }
    }
}

