/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.IntIntFunction;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TroveUtil {
    @NotNull
    public static <T> Stream<T> streamValues(@NotNull TIntObjectHashMap<T> map2) {
        TIntObjectIterator it = map2.iterator();
        return Stream.generate(() -> {
            it.advance();
            return it.value();
        }).limit(map2.size());
    }

    @NotNull
    public static IntStream streamKeys(@NotNull TIntObjectHashMap<?> map2) {
        TIntObjectIterator it = map2.iterator();
        return IntStream.generate(() -> {
            it.advance();
            return it.key();
        }).limit(map2.size());
    }

    @NotNull
    public static IntStream stream(@NotNull TIntArrayList list2) {
        if (list2.isEmpty()) {
            return IntStream.empty();
        }
        return IntStream.range(0, list2.size()).map(arg_0 -> ((TIntArrayList)list2).get(arg_0));
    }

    @NotNull
    public static Set<Integer> intersect(TIntHashSet ... sets) {
        TIntHashSet result2 = null;
        Arrays.sort(sets, (set1, set2) -> {
            if (set1 == null) {
                return -1;
            }
            if (set2 == null) {
                return 1;
            }
            return set1.size() - set2.size();
        });
        for (TIntHashSet set3 : sets) {
            result2 = TroveUtil.intersect(result2, set3);
        }
        if (result2 == null) {
            return ContainerUtil.newHashSet();
        }
        return TroveUtil.createJavaSet(result2);
    }

    public static boolean intersects(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        if (set1.size() <= set2.size()) {
            return !set1.forEach(value -> !set2.contains(value));
        }
        return TroveUtil.intersects(set2, set1);
    }

    @Nullable
    private static TIntHashSet intersect(@Nullable TIntHashSet set1, @Nullable TIntHashSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        TIntHashSet result2 = new TIntHashSet();
        if (set1.size() < set2.size()) {
            TroveUtil.intersectTo(set1, set2, result2);
        } else {
            TroveUtil.intersectTo(set2, set1, result2);
        }
        return result2;
    }

    private static void intersectTo(@NotNull TIntHashSet small, @NotNull TIntHashSet big, @NotNull TIntHashSet result2) {
        small.forEach(value -> {
            if (big.contains(value)) {
                result2.add(value);
            }
            return true;
        });
    }

    @NotNull
    private static Set<Integer> createJavaSet(@NotNull TIntHashSet set2) {
        HashSet result2 = ContainerUtil.newHashSet((int)set2.size());
        set2.forEach(value -> {
            result2.add(value);
            return true;
        });
        return result2;
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull TIntHashSet what) {
        what.forEach(value -> {
            where.add(value);
            return true;
        });
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull Collection<Integer> what) {
        what.forEach(value -> where.add(value.intValue()));
    }

    public static void addAll(@NotNull Collection<Integer> where, @NotNull TIntHashSet what) {
        what.forEach(value -> where.add(value));
    }

    public static <V> void putAll(@NotNull TIntObjectHashMap<? super V> where, @NotNull TIntObjectHashMap<? extends V> what) {
        what.forEachEntry((index, value) -> {
            where.put(index, value);
            return true;
        });
    }

    @NotNull
    public static IntStream stream(@NotNull TIntHashSet set2) {
        TIntIterator it = set2.iterator();
        return IntStream.generate(() -> ((TIntIterator)it).next()).limit(set2.size());
    }

    @NotNull
    public static <T> List<T> map2List(@NotNull TIntHashSet set2, @NotNull IntFunction<? extends T> function) {
        return TroveUtil.stream(set2).mapToObj(function).collect(Collectors.toList());
    }

    @NotNull
    public static TIntHashSet map2IntSet(@NotNull TIntHashSet set2, @NotNull IntIntFunction function) {
        TIntHashSet result2 = new TIntHashSet();
        set2.forEach(it -> {
            result2.add(function.fun(it));
            return true;
        });
        return result2;
    }

    @NotNull
    public static <T> TIntObjectHashMap<T> map2MapNotNull(@NotNull TIntHashSet set2, @NotNull IntFunction<? extends T> function) {
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        set2.forEach(it -> {
            Object value = function.apply(it);
            if (value != null) {
                result2.put(it, value);
            }
            return true;
        });
        return result2;
    }

    @NotNull
    public static <T> TIntHashSet map2IntSet(@NotNull Collection<? extends T> set2, @NotNull ToIntFunction<? super T> function) {
        TIntHashSet result2 = new TIntHashSet();
        for (T t : set2) {
            result2.add(function.applyAsInt(t));
        }
        return result2;
    }

    @NotNull
    public static <T> Map<T, TIntHashSet> group(@NotNull TIntHashSet set2, @NotNull IntFunction<? extends T> function) {
        HashMap result2 = ContainerUtil.newHashMap();
        set2.forEach(it -> {
            Object key = function.apply(it);
            TIntHashSet values = (TIntHashSet)result2.get(key);
            if (values == null) {
                values = new TIntHashSet();
                result2.put(key, values);
            }
            values.add(it);
            return true;
        });
        return result2;
    }

    public static void processBatches(@NotNull IntStream stream, int batchSize, @NotNull ThrowableConsumer<? super TIntHashSet, ? extends VcsException> consumer) throws VcsException {
        Ref batch = new Ref((Object)new TIntHashSet());
        Ref exception = new Ref();
        stream.forEach(commit2 -> {
            ((TIntHashSet)batch.get()).add(commit2);
            if (((TIntHashSet)batch.get()).size() >= batchSize) {
                try {
                    consumer.consume(batch.get());
                }
                catch (VcsException e) {
                    exception.set((Object)e);
                }
                finally {
                    batch.set((Object)new TIntHashSet());
                }
            }
        });
        if (!((TIntHashSet)batch.get()).isEmpty()) {
            consumer.consume(batch.get());
        }
        if (!exception.isNull()) {
            throw (VcsException)((Object)exception.get());
        }
    }

    @NotNull
    public static TIntHashSet collect(@NotNull IntStream stream) {
        TIntHashSet result2 = new TIntHashSet();
        stream.forEach(arg_0 -> ((TIntHashSet)result2).add(arg_0));
        return result2;
    }

    @NotNull
    public static TIntHashSet singleton(@NotNull Integer elements) {
        TIntHashSet commits = new TIntHashSet();
        commits.add(elements.intValue());
        return commits;
    }

    public static <T> void add(@NotNull Map<? super T, TIntHashSet> targetMap, @NotNull T key, int value) {
        TIntHashSet set2 = targetMap.get(key);
        if (set2 == null) {
            set2 = new TIntHashSet();
            targetMap.put(key, set2);
        }
        set2.add(value);
    }

    public static boolean removeAll(@NotNull TIntHashSet fromWhere, @NotNull TIntHashSet what) {
        Ref result2 = new Ref((Object)false);
        what.forEach(it -> {
            if (fromWhere.remove(it)) {
                result2.set((Object)true);
            }
            return true;
        });
        return (Boolean)result2.get();
    }

    public static boolean removeAll(@NotNull TIntHashSet fromWhere, @NotNull Set<Integer> what) {
        boolean result2 = false;
        for (int i : what) {
            if (!fromWhere.remove(i)) continue;
            result2 = true;
        }
        return result2;
    }
}

